<?php
/*
 * This is the config file for the theme.
 */

define("TD_THEME_DEMO_URL", "https://demo.tagdiv.com/" . strtolower(TD_THEME_NAME));
define("TD_THEME_DEMO_DOC_URL", 'https://tagdiv.com/newspaper-theme-installing-demos/');  //the url to the demo documentation
define("TD_PLUGINS_URL", 'https://cloud.tagdiv.com/td_plugins/');  //plugins url
define("TD_FEATURED_CAT", "Featured"); //featured cat name
define("TD_FEATURED_CAT_SLUG", "featured"); //featured cat slug

define("TD_AURORA_VERSION", "__td_aurora_deploy_version__");

define("TD_THEME_WP_BOOSTER", "3.0"); // prevents multiple instances of the framework





/**
 * speed booster v 3.0 hooks - prepare the framework for the theme
 * is also used by td_deploy - that's why it's a static class
 * Class td_wp_booster_hooks
 */
class td_config {


    /**
     * @throws ErrorException
     */
    static function on_td_global_after_config() {



        /**
         * js files list
         */
        td_global::$js_files = array(


	        'tdAnalytics' =>            '/legacy/common/wp_booster/js_dev/tdAnalytics.js',
	        'tdExternal' =>             '/legacy/common/wp_booster/js_dev/tdExternal.js',
            'tdDetect' =>               '/legacy/common/wp_booster/js_dev/tdDetect.js',

	        'tdViewport' =>             '/legacy/common/wp_booster/js_dev/tdViewport.js',

            'tdMenu' =>                 '/legacy/common/wp_booster/js_dev/tdMenu.js',
            //'tdLocalCache' =>         '/includes/wp_booster/js_dev/tdLocalCache.js',
            'tdUtil' =>                 '/legacy/common/wp_booster/js_dev/tdUtil.js',
            'tdAffix' =>                '/legacy/common/wp_booster/js_dev/tdAffix.js',
            //'td_scroll_animation' =>  '/includes/wp_booster/js_dev/td_scroll_animation.js',
            'td_site' =>                '/legacy/common/wp_booster/js_dev/td_site.js',

            'tdLoadingBox' =>           '/legacy/common/wp_booster/js_dev/tdLoadingBox.js',
            'tdAjaxSearch' =>           '/legacy/common/wp_booster/js_dev/tdAjaxSearch.js',
            'tdPostImages' =>           '/legacy/common/wp_booster/js_dev/tdPostImages.js',
            'tdBlocks' =>               '/legacy/common/wp_booster/js_dev/tdBlocks.js',
            'tdLogin' =>                '/legacy/common/wp_booster/js_dev/tdLogin.js',
            'tdLoginMobile' =>          '/legacy/common/wp_booster/js_dev/tdLoginMobile.js',
            'tdStyleCustomizer' =>      '/legacy/common/wp_booster/js_dev/tdStyleCustomizer.js',
            'tdTrendingNow' =>          '/legacy/common/wp_booster/js_dev/tdTrendingNow.js',
            //'tdTrendingNowCustom' =>    '/legacy/common/wp_booster/js_dev/tdTrendingNowCustom.js',
            'td_history' =>             '/legacy/common/wp_booster/js_dev/td_history.js',
            'tdSmartSidebar' =>         '/legacy/common/wp_booster/js_dev/tdSmartSidebar.js',
            'tdStickyRow' =>            '/legacy/common/wp_booster/js_dev/tdStickyRow.js',
            'tdScrollToClass' =>        '/legacy/common/wp_booster/js_dev/tdScrollToClass.js',
            'tdInfiniteLoader' =>       '/legacy/common/wp_booster/js_dev/tdInfiniteLoader.js',
	        'vimeo_froogaloop' =>       '/legacy/common/wp_booster/js_dev/vimeo_froogaloop.js',

	        'tdCustomEvents' =>         '/legacy/' . TD_THEME_NAME . '/includes/js_files/tdCustomEvents.js',
	        'tdEvents' =>               '/legacy/common/wp_booster/js_dev/tdEvents.js',

	        'tdHeader' =>               '/legacy/common/wp_booster/js_dev/tdHeader.js',

	        'tdAjaxCount' =>            '/legacy/common/wp_booster/js_dev/tdAjaxCount.js',
            'tdVideoPlaylist' =>        '/legacy/common/wp_booster/js_dev/tdVideoPlaylist.js',
	        'td_slide' =>               '/legacy/common/wp_booster/js_dev/td_slide.js',
            'tdPullDown' =>             '/legacy/common/wp_booster/js_dev/tdPullDown.js',

            //'td_main' =>              '/includes/js_files/td_main.js',
            'td_fps' =>                 '/legacy/' . TD_THEME_NAME . '/includes/js_files/td_fps.js',
	        'tdAnimationScroll' =>      '/legacy/common/wp_booster/js_dev/tdAnimationScroll.js',
	        'tdHomepageFull' =>         '/legacy/common/wp_booster/js_dev/tdHomepageFull.js',
	        'tdBackstr' =>              '/legacy/common/wp_booster/js_dev/tdBackstr.js',
	        'tdShowVideo' =>            '/legacy/common/wp_booster/js_dev/tdShowVideo.js',

            //'td_scroll_effects.js' => '/includes/js_files/td_scroll_effects.js',

	        'tdAnimationStack' =>       '/legacy/common/wp_booster/js_dev/tdAnimationStack.js',
	        'td_main' =>                '/legacy/' . TD_THEME_NAME . '/includes/js_files/td_main.js',

            'td_loop_ajax' =>           '/legacy/common/wp_booster/js_dev/tdLoopAjax.js',

	        'tdWeather' =>              '/legacy/common/wp_booster/js_dev/tdWeather.js',
            'tdLastInit' =>             '/legacy/common/wp_booster/js_dev/tdLastInit.js',
            'tdAnimationSprite' =>      '/legacy/common/wp_booster/js_dev/tdAnimationSprite.js',
            'tdDatei18n' =>             '/legacy/common/wp_booster/js_dev/tdDatei18n.js',
            'tdSocialSharing'=>         '/legacy/common/wp_booster/js_dev/tdSocialSharing.js',

            'tdModalPostImages' =>      '/legacy/common/wp_booster/js_dev/tdModalPostImages.js',

            'tdAjaxVideoModal' =>       '/legacy/common/wp_booster/js_dev/tdAjaxVideoModal.js',

            'tdfAjaxFlickr' =>       '/legacy/common/wp_booster/js_dev/tdfAjaxFlickr.js',

	        'td_confirm' => '/legacy/common/wp_booster/wp-admin/js/tdConfirm.js',

        );


	    /**
	     * tdViewport intervals in crescendo order
	     */
	    td_global::$td_viewport_intervals = array(
		    array(
			    "limitBottom" => 767,
			    "sidebarWidth" => 228,
		    ),
		    array(
			    "limitBottom" => 1018,
			    "sidebarWidth" => 300,
		    ),
		    array(
			    "limitBottom" => 1140,
			    "sidebarWidth" => 324,
		    ),
	    );


	    /**
	     * - td animation stack effects used in the 'loading animation image' theme panel section
	     * - the first element is a special case, it representing the default type 'type0' @see animation-stack.less
	     * - the 'val' parameter is the type effect
	     * - the 'specific_selectors' parameter is the css selector used to look for new elements inside of some specific sections [ex. at ajax req]
	     * - the 'general_selectors' parameter is the css selector used to look for elements on extended sections [ex. entire page]
	     * - Important! the 'general_selectors' is not used by the default 'type0'
	     */
	    td_global::$td_animation_stack_effects = array(
		    array(
			    'text' => 'Fade [full]',
			    'val' => '', // empty, as a default value
			    'specific_selectors' => '.entry-thumb, img, .td-lazy-img',
			    'general_selectors' => '.td-animation-stack img, .td-animation-stack .entry-thumb, .post img, .td-animation-stack .td-lazy-img',
		    ),

            array(
                'text' => 'Fade & Scale',
                'val' => 'type1',
                'specific_selectors' => '.entry-thumb, img[class*="wp-image-"], a.td-sml-link-to-image > img, .td-lazy-img',
                'general_selectors' => '.td-animation-stack .entry-thumb, .post .entry-thumb, .post img[class*="wp-image-"], .post a.td-sml-link-to-image > img, .td-animation-stack .td-lazy-img',
            ),


            array(
                'text' => 'Up fade',
                'val' => 'type2',
                'specific_selectors' => '.entry-thumb, img[class*="wp-image-"], a.td-sml-link-to-image > img, .td-lazy-img',
                'general_selectors' => '.td-animation-stack .entry-thumb, .post .entry-thumb, .post img[class*="wp-image-"], a.td-sml-link-to-image > img, .td-animation-stack .td-lazy-img',
            ),


        );



        /**
         * single template list
         */
        td_api_single_template::add('single_template',
            array(
                'file' => TDC_PATH_LEGACY . '/single.php',
                'text' => 'Single template',
                'img' => TDC_URL_LEGACY . '/assets/images/panel/single_templates/single_template_0.png',
                'show_featured_image_on_all_pages' => false,
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
                'exclude_ad_content_top' => false,
            )
        );



        /**
		 * block templates
		 */
        td_api_block_template::add('td_block_template_1',
            array (
                'text' => 'Block Header 1 - Default',
                'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-1.png',
                'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_1.php',
                'params' => array(
                    // title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title background color:',
                        "param_name" => "header_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom background color for this header',
                        'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_background_color.png",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title text color:',
                        "param_name" => "header_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom title text color for this header',
                        'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Accent hover color:',
                        "param_name" => "accent_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom accent hover color for this block',
                        'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
                    )
                )//end generic array
            )
        );

		td_api_block_template::add('td_block_template_2',
		    array (
		        'text' => 'Block Header 2',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-2.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_2.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_3',
		    array (
		        'text' => 'Block Header 3',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-3.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_3.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title background color:',
		                "param_name" => "header_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom background color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_background_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_4',
		    array (
		        'text' => 'Block Header 4',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-4.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_4.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title background color:',
		                "param_name" => "header_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom background color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_background_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_5',
		    array (
		        'text' => 'Block Header 5',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-5.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_5.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title background color:',
		                "param_name" => "header_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom background color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_background_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_6',
		    array (
		        'text' => 'Block Header 6',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-6.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_6.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "attach_image",
		                "holder" => "div",
		                "class" => "",
		                "heading" => "Header background",
		                "param_name" => "header_image",
		                "value" => '',
		                "description" => "Optional - Choose a custom background image for this header",
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_7',
		    array (
		        'text' => 'Block Header 7',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-7.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_7.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title background color:',
		                "param_name" => "header_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom background color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_background_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            ),
		            array(
		                "type" => "attach_image",
		                "holder" => "div",
		                "class" => "",
		                "heading" => "Header pattern",
		                "param_name" => "header_image",
		                "value" => '',
		                "description" => "Optional - Choose a custom background image for this header",
		                'td_type' => 'block_template',
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_8',
		    array (
		        'text' => 'Block Header 8',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-8.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_8.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Border color:',
		                "param_name" => "border_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom border color for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_9',
		    array (
		        'text' => 'Block Header 9',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-9.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_9.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Border color:',
		                "param_name" => "border_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom border color for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_10',
		    array (
		        'text' => 'Block Header 10',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-10.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_10.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Border color:',
		                "param_name" => "border_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom border color for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_11',
		    array (
		        'text' => 'Block Header 11',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-11.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_11.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Border color:',
		                "param_name" => "border_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom border color for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_12',
		    array (
		        'text' => 'Block Header 12',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-12.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_12.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            ),
		            array(
		                "type" => "textfield",
		                "holder" => "div",
		                "class" => "tdc-textfield-big",
		                "heading" => 'Continue button text:',
		                "param_name" => "button_text",
		                "value" => '',
		                "description" => 'To enable the continue button, choose a category from Filter or write a custom Title URL',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Continue button color:',
		                "param_name" => "button_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom text color for the continue button',
		                'td_type' => 'block_template',
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_13',
		    array (
		        'text' => 'Block Header 13',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-13.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_13.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            ),
		            array(
		                "type" => "textfield",
		                "holder" => "div",
		                "class" => "tdc-textfield-big",
		                "heading" => 'Big title:',
		                "param_name" => "big_title_text",
		                "value" => '',
		                "description" => 'Optional - Choose a custom big title text for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Big title text color:',
		                "param_name" => "big_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom color for the big title',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "textfield",
		                "holder" => "div",
		                "class" => "tdc-textfield-big",
		                "heading" => 'Continue button text:',
		                "param_name" => "button_text",
		                "value" => '',
		                "description" => 'To enable the continue button, choose a category from Filter or write a custom Title URL',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Continue button color:',
		                "param_name" => "button_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom text color for the continue button',
		                'td_type' => 'block_template',
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_14',
		    array (
		        'text' => 'Block Header 14',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-14.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_14.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title background color:',
		                "param_name" => "header_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom background color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_background_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Border color:',
		                "param_name" => "border_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom border color for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_15',
		    array (
		        'text' => 'Block Header 15',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-15.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_15.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title background color:',
		                "param_name" => "header_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom background color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_background_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Border color:',
		                "param_name" => "border_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom border color for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Top border color:',
		                "param_name" => "top_border_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom top border color for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_16',
		    array (
		        'text' => 'Block Header 16',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-16.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_16.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Border color:',
		                "param_name" => "border_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom border color for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_17',
		    array (
		        'text' => 'Block Header 17',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-17.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_17.php',
		        'params' => array(
		            // title settings
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title text color:',
		                "param_name" => "header_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom title text color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_text_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title background color:',
		                "param_name" => "header_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom background color for this header',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_background_color.png",
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Border top color:',
		                "param_name" => "top_border_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom top border color for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Border bottom color:',
		                "param_name" => "bottom_border_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom bottom border color for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        )//end generic array
		    )
		);

		td_api_block_template::add('td_block_template_18',
		    array (
		        'text' => 'Block Header 18',
		        'img' => TDC_URL_LEGACY . '/assets/images/panel/block_templates/icon-block-header-18.png',
		        'file' => TDC_PATH_LEGACY . '/includes/block_templates/td_block_template_18.php',
		        'params' => array(
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title gradient color A:',
		                "param_name" => "header_text_color_a",
		                "value" => '#06d3d5',
		                "description" => 'Optional - Choose a custom title gradient color for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Title gradient color B:',
		                "param_name" => "header_text_color_b",
		                "value" => '#2a81cb',
		                "description" => 'Optional - Choose a custom title gradient color for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "textfield",
		                "holder" => "div",
		                "class" => "tdc-textfield-big",
		                "heading" => 'Speech bubble text:',
		                "param_name" => "speech_bubble_text",
		                "value" => '',
		                "description" => 'Optional - Custom text for the speech bubble',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Speech bubble color:',
		                "param_name" => "speech_bubble_color",
		                "value" => '#2a81cb',
		                "description" => 'Optional - Speech bubble background color',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "textfield",
		                "holder" => "div",
		                "class" => "tdc-textfield-extrabig",
		                "heading" => 'Subtitle text:',
		                "param_name" => "subtitle_text",
		                "value" => '',
		                "description" => 'Optional - Choose a custom subtitle text for this header',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Subtitle text color:',
		                "param_name" => "subtitle_text_color",
		                "value" => '#808080',
		                "description" => 'Optional - Choose a custom color for the subtitle text',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Subtitle border color:',
		                "param_name" => "subtitle_border_color",
		                "value" => '#e3e3e3',
		                "description" => 'Optional - Choose a custom color for the subtitle border',
		                'td_type' => 'block_template',
		            ),
		            array(
		                "type" => "colorpicker",
		                "holder" => "div",
		                "class" => "",
		                "heading" => 'Accent hover color:',
		                "param_name" => "accent_text_color",
		                "value" => '',
		                "description" => 'Optional - Choose a custom accent hover color for this block',
		                'td_type' => 'block_template',
                        "info_img" => "https://cloud.tagdiv.com/help/title_active.png",
		            )
		        ),//end generic array
		        'premium' => true
		    )
		);



        /**
		 * modules list
		 */
        td_api_module::add('td_module_single',
            array(  // this module is for internal use only
                'file' => TDC_PATH_LEGACY . '/includes/modules/td_module_single.php',
                'text' => 'Single Module',
                'img' => '',
                'used_on_blocks' => '',
                'excerpt_title' => '',
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => false,
                'class' => '',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_slide',
            array(
                'file' => TDC_PATH_LEGACY . '/includes/modules/td_module_slide.php',
                'text' => 'Slider module',
                'img' => '',
                'used_on_blocks' => array('td_block_slide'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );


        td_api_module::add('td_module_mega_menu',
            array(
                'file' => TDC_PATH_LEGACY . '/includes/modules/td_module_mega_menu.php',
                'text' => 'Mega menu module',
                'img' => '',
                'used_on_blocks' => array('td_block_mega_menu'),
                'excerpt_title' => '12',
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );
		td_api_module::add('td_module_trending_now',
		    array(  // this module is for internal use only
		        'file' => TDC_PATH_LEGACY . '/includes/modules/td_module_trending_now.php',
		        'text' => 'Trending now module',
		        'img' => '',
		        'used_on_blocks' => '',
		        'excerpt_title' => 25,
		        'excerpt_content' => '',
		        'enabled_on_more_articles_box' => false,
		        'enabled_on_loops' => false,
		        'uses_columns' => false,                      // if the module uses columns on the page template + loop
		        'category_label' => false,
		        'class' => '',
		        'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
		    )
		);
        td_api_module::add( 'td_module_flex_1',
            array(
                'file'                         => TDC_PATH_LEGACY . '/includes/modules/td_module_flex_1.php',
                'text'                         => 'Module Flex 1',
                'img'                          => '',
                'used_on_blocks'               => array( 'td_flex_block_1' ),
                'excerpt_title'                => 25,
                'excerpt_content'              => 25,
                'enabled_excerpt_in_panel'     => false,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops'             => false,
                'uses_columns'                 => false,
                // if the module uses columns on the page template + loop
                'category_label'               => false,
                'class'                        => 'td_module_wrap td-animation-stack',
                'group'                        => ''
                // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );



		td_api_module::add( 'td_module_flex_2',
		    array(
		        'file'                         => TDC_PATH_LEGACY . '/includes/modules/td_module_flex_2.php',
		        'text'                         => 'Module Flex 2',
		        'img'                          => '',
		        'used_on_blocks'               => array( 'td_flex_block_2' ),
		        'excerpt_title'                => 25,
		        'excerpt_content'              => 25,
                'enabled_excerpt_in_panel'     => false,
		        'enabled_on_more_articles_box' => false,
		        'enabled_on_loops'             => false,
		        'uses_columns'                 => false,
		        // if the module uses columns on the page template + loop
		        'category_label'               => false,
		        'class'                        => 'td_module_wrap td-animation-stack',
		        'group'                        => ''
		        // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
		    )
		);

		td_api_module::add( 'td_module_flex_3',
		    array(
		        'file'                         => TDC_PATH_LEGACY . '/includes/modules/td_module_flex_3.php',
		        'text'                         => 'Module Flex 3',
		        'img'                          => '',
		        'used_on_blocks'               => array( 'td_flex_block_3' ),
		        'excerpt_title'                => 25,
		        'excerpt_content'              => 25,
                'enabled_excerpt_in_panel'     => false,
		        'enabled_on_more_articles_box' => false,
		        'enabled_on_loops'             => false,
		        'uses_columns'                 => false,
		        // if the module uses columns on the page template + loop
		        'category_label'               => false,
		        'class'                        => 'td_module_wrap td-animation-stack',
		        'group'                        => ''
		        // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
		    )
		);

		td_api_module::add( 'td_module_flex_4',
		    array(
		        'file'                         => TDC_PATH_LEGACY . '/includes/modules/td_module_flex_4.php',
		        'text'                         => 'Module Flex 4',
		        'img'                          => '',
		        'used_on_blocks'               => array( 'td_flex_block_4' ),
		        'excerpt_title'                => 25,
		        'excerpt_content'              => 25,
                'enabled_excerpt_in_panel'     => false,
		        'enabled_on_more_articles_box' => false,
		        'enabled_on_loops'             => false,
		        'uses_columns'                 => false,
		        // if the module uses columns on the page template + loop
		        'category_label'               => false,
		        'class'                        => 'td_module_wrap td-animation-stack',
		        'group'                        => ''
		        // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
		    )
		);

		td_api_module::add( 'td_module_flex_5',
		    array(
		        'file'                         => TDC_PATH_LEGACY . '/includes/modules/td_module_flex_5.php',
		        'text'                         => 'Module Flex 5',
		        'img'                          => '',
		        'used_on_blocks'               => array( 'td_module_flex_5' ),
		        'excerpt_title'                => 25,
		        'excerpt_content'              => 25,
                'enabled_excerpt_in_panel'     => false,
		        'enabled_on_more_articles_box' => false,
		        'enabled_on_loops'             => false,
		        'uses_columns'                 => false,
		        // if the module uses columns on the page template + loop
		        'category_label'               => false,
		        'class'                        => 'td_module_wrap td-animation-stack',
		        'group'                        => ''
		        // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
		    )
		);

		td_api_module::add( 'td_module_flex_6',
		    array(
		        'file'                         => TDC_PATH_LEGACY . '/includes/modules/td_module_flex_6.php',
		        'text'                         => 'Module Flex 6',
		        'img'                          => '',
		        'used_on_blocks'               => array( 'td_module_flex_6' ),
		        'excerpt_title'                => 25,
		        'excerpt_content'              => 0,
                'enabled_excerpt_in_panel'     => false,
		        'enabled_on_more_articles_box' => false,
		        'enabled_on_loops'             => false,
		        'uses_columns'                 => false,
		        // if the module uses columns on the page template + loop
		        'category_label'               => false,
		        'class'                        => 'td-animation-stack',
		        'group'                        => ''
		        // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
		    )
		);

		td_api_module::add( 'td_module_flex_7',
		    array(
		        'file'                         => TDC_PATH_LEGACY . '/includes/modules/td_module_flex_7.php',
		        'text'                         => 'Module Flex 7',
		        'img'                          => '',
		        'used_on_blocks'               => array( 'td_module_flex_7' ),
		        'excerpt_title'                => 25,
		        'excerpt_content'              => 0,
                'enabled_excerpt_in_panel'     => false,
		        'enabled_on_more_articles_box' => false,
		        'enabled_on_loops'             => false,
		        'uses_columns'                 => false,
		        // if the module uses columns on the page template + loop
		        'category_label'               => false,
		        'class'                        => 'td-animation-stack',
		        'group'                        => ''
		        // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
		    )
		);

		td_api_module::add( 'td_module_flex_8',
		    array(
		        'file'                         => TDC_PATH_LEGACY . '/includes/modules/td_module_flex_8.php',
		        'text'                         => 'Module Flex 8',
		        'img'                          => '',
		        'used_on_blocks'               => array( 'td_module_flex_8' ),
		        'excerpt_title'                => 25,
		        'excerpt_content'              => 0,
                'enabled_excerpt_in_panel'     => false,
		        'enabled_on_more_articles_box' => false,
		        'enabled_on_loops'             => false,
		        'uses_columns'                 => false,
		        // if the module uses columns on the page template + loop
		        'category_label'               => false,
		        'class'                        => 'td-animation-stack',
		        'group'                        => ''
		        // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
		    )
		);

		td_api_module::add( 'td_module_flex_empty',
		    array(
		        'file'                         => TDC_PATH_LEGACY . '/includes/modules/td_module_flex_empty.php',
		        'text'                         => 'Module Flex Empty',
		        'img'                          => '',
		        'used_on_blocks'               => array( 'td_module_flex_empty' ),
		        'excerpt_title'                => 25,
		        'excerpt_content'              => 0,
                'enabled_excerpt_in_panel'     => false,
		        'enabled_on_more_articles_box' => false,
		        'enabled_on_loops'             => false,
		        'uses_columns'                 => false,
		        // if the module uses columns on the page template + loop
		        'category_label'               => false,
		        'class'                        => 'td-animation-stack',
		        'group'                        => ''
		        // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
		    )
		);




		/**
		 * the blocks
		 */
        td_api_block::add('td_block_ad_box',
            array(
                'map_in_visual_composer' => true,
                'map_in_td_composer' => true,
                "name" => 'Ad box',
                "base" => 'td_block_ad_box',
                "class" => "",
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Extended',
                'icon' => 'icon-pagebuilder-ads',
                'file' => TDC_PATH_LEGACY . '/includes/shortcodes/td_block_ad_box.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'spot_id',
                    'spot_title',
                    'el_class'
                ),
                'tdc_start_values'       => base64_encode(
                    json_encode(
                        array(
                            array(
                                "spot_img_horiz" => "content-horiz-center",
                            )
                        )
                    )
                ),
                "params" => array_merge(
                    self::get_map_block_general_array(),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Ad content',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "spot_id",
                            "type" => "dropdown",
                            "value" => array(
                                '- Select an ad spot -' => '',
                                'header' => 'header',
                                'sidebar' => 'sidebar',
                                'custom_ad_1' => 'custom_ad_1',
                                'custom_ad_2' => 'custom_ad_2',
                                'custom_ad_3' => 'custom_ad_3',
                                'custom_ad_4' => 'custom_ad_4',
                                'custom_ad_5' => 'custom_ad_5'
                            ),
                            "heading" => 'Use adspot from:',
                            "description" => 'Choose the adspot from list',
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/rec_general_select_anim.png"
                        ),
                        array(
                            "param_name" => "spot_hide",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Hide ads for admins/editors",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => ''
                        ),

                        array(
                            "param_name" => "spot_title",
                            "type" => "textfield",
                            "value" => "",
                            "heading" => 'Ad title:',
                            "description" => "Optional - a title for the Ad, like - Advertisement - if you leave it blank the block will not have a title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig",
                            "info_img" => "https://cloud.tagdiv.com/help/rec_general_title_anim.png"
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Ad title color',
                            "param_name"  => "ad_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                            "info_img" => "https://cloud.tagdiv.com/help/rec_general_title_color_anim.png"
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title', true, 'Ad title text' ),
                    array(
                        array(
                            "param_name" => "spot_img_all",
                            "type" => "attach_image",
                            "value" => '',
                            "heading" => "All devices",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Image ad'
                        ),
	                    array(
		                    "param_name" => "spot_img_all_width_attribute",
		                    "type" => "textfield",
		                    "value" => "",
		                    "placeholder" => "",
		                    "heading" => 'Width attribute',
		                    "description" => "",
		                    "holder" => "div",
		                    "class" => "tdc-textfield-small",
		                    "group" => 'Image ad',
                            "info_img" => "https://cloud.tagdiv.com/help/rec_image_width_anim.png",
	                    ),
	                    array(
		                    "param_name" => "spot_img_all_height_attribute",
		                    "type" => "textfield",
		                    "value" => "",
		                    "placeholder" => "",
		                    "heading" => 'Height attribute',
		                    "description" => "",
		                    "holder" => "div",
		                    "class" => "tdc-textfield-small",
		                    "group" => 'Image ad'
	                    ),
	                    array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"      => 'Image ad'
	                    ),
                        array(
                            "param_name" => "spot_img_tl",
                            "type" => "attach_image",
                            "value" => '',
                            "heading" => "Tablet landscape",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Image ad'
                        ),
	                    array(
		                    "param_name" => "spot_img_tl_width_attribute",
		                    "type" => "textfield",
		                    "value" => "",
		                    "placeholder" => "",
		                    "heading" => 'Width attribute',
		                    "description" => "",
		                    "holder" => "div",
		                    "class" => "tdc-textfield-small",
		                    "group" => 'Image ad',
                            "info_img" => "https://cloud.tagdiv.com/help/rec_image_width_anim.png",
	                    ),
	                    array(
		                    "param_name" => "spot_img_tl_height_attribute",
		                    "type" => "textfield",
		                    "value" => "",
		                    "placeholder" => "",
		                    "heading" => 'Height attribute',
		                    "description" => "",
		                    "holder" => "div",
		                    "class" => "tdc-textfield-small",
		                    "group" => 'Image ad'
	                    ),
	                    array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"      => 'Image ad'
	                    ),
                        array(
                            "param_name" => "spot_img_tp",
                            "type" => "attach_image",
                            "value" => '',
                            "heading" => "Tablet portrait",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Image ad'
                        ),

	                    array(
		                    "param_name" => "spot_img_tp_width_attribute",
		                    "type" => "textfield",
		                    "value" => "",
		                    "placeholder" => "",
		                    "heading" => 'Width attribute',
		                    "description" => "",
		                    "holder" => "div",
		                    "class" => "tdc-textfield-small",
		                    "group" => 'Image ad',
                            "info_img" => "https://cloud.tagdiv.com/help/rec_image_width_anim.png",
	                    ),
	                    array(
		                    "param_name" => "spot_img_tp_height_attribute",
		                    "type" => "textfield",
		                    "value" => "",
		                    "placeholder" => "",
		                    "heading" => 'Height attribute',
		                    "description" => "",
		                    "holder" => "div",
		                    "class" => "tdc-textfield-small",
		                    "group" => 'Image ad'
	                    ),
	                    array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"      => 'Image ad'
	                    ),
                        array(
                            "param_name" => "spot_img_mob",
                            "type" => "attach_image",
                            "value" => '',
                            "heading" => "Phone",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Image ad'
                        ),
	                    array(
		                    "param_name" => "spot_img_mob_width_attribute",
		                    "type" => "textfield",
		                    "value" => "",
		                    "placeholder" => "",
		                    "heading" => 'Width attribute',
		                    "description" => "",
		                    "holder" => "div",
		                    "class" => "tdc-textfield-small",
		                    "group" => 'Image ad',
                            "info_img" => "https://cloud.tagdiv.com/help/rec_image_width_anim.png",
	                    ),
	                    array(
		                    "param_name" => "spot_img_mob_height_attribute",
		                    "type" => "textfield",
		                    "value" => "",
		                    "placeholder" => "",
		                    "heading" => 'Height attribute',
		                    "description" => "",
		                    "holder" => "div",
		                    "class" => "tdc-textfield-small",
		                    "group" => 'Image ad'
	                    ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"      => 'Image ad'
                        ),
                        array(
                            "param_name" => "spot_url",
                            "type" => "textfield",
                            "value" => "",
                            "heading" => 'Ad url',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig",
                            "group" => 'Image ad'
                        ),
                        array(
                            "param_name" => "spot_url_window",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Open url in new window",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Image ad'
                        ),
                        array(
                            "param_name" => "spot_url_rel",
                            "type" => "dropdown",
                            "value" => array(
                                'None' => '',
                                'Nofollow' => 'nofollow',
                                'Noreferrer' => 'noreferrer',
                                'Noopener' => 'noopener'
                            ),
                            "heading" => 'Spot url rel',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => 'Image ad'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"      => 'Image ad'
                        ),
	                    array(
		                    "param_name" => "spot_img_alt_attribute",
		                    "type" => "textfield",
		                    "value" => "",
		                    "placeholder" => "",
		                    "heading" => 'Alt attribute',
		                    "description" => "",
		                    "holder" => "div",
		                    "class" => "tdc-textfield-big",
		                    "group" => 'Image ad'
	                    ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"      => 'Image ad'
                        ),
                        array(
                            "param_name" => "spot_img_all_hide",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Hide on desktop",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Image ad'
                        ),
                        array(
                            "param_name" => "spot_img_tl_hide",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Hide on tablet landscape",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Image ad'
                        ),
                        array(
                            "param_name" => "spot_img_tp_hide",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Hide on tablet portrait",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Image ad'
                        ),
                        array(
                            "param_name" => "spot_img_mob_hide",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Hide on phone",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Image ad'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "",
                            "group" => 'Image ad'
                        ),
                        array(
                            "param_name" => "spot_img_width",
                            "type" => "textfield-responsive",
                            "value" => "",
                            "placeholder" => "auto",
                            "heading" => 'Width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "group" => 'Image ad',
                            "info_img" => "https://cloud.tagdiv.com/help/rec_image_width_anim.png"
                        ),
                        array(
                            "param_name" => "spot_img_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group" => 'Image ad',
                            "info_img" => "https://cloud.tagdiv.com/help/rec_image_horizontal_anim.png"
                        ),

                        array(
                            "param_name" => "spot_code",
                            "type" => "textarea_raw_html",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Custom ad code',
                            "value" => "",
                            "description" => 'Paste your ad code here.',
                            'group'      => 'Custom ad',
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => ""
                        ),
                        array(
                            'param_name' => 'el_class',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Extra class',
                            'description' => 'Style particular content element differently - add a class name and refer to it in custom CSS',
                            'class' => 'tdc-textfield-extrabig',
                        ),
                        array (
                            'param_name' => 'css',
                            'value' => '',
                            'type' => 'css_editor',
                            'heading' => 'Css',
                            'group' => 'Design options',
                        ),
                        array (
                            'param_name' => 'tdc_css',
                            'value' => '',
                            'type' => 'tdc_css_editor',
                            'heading' => '',
                            'group' => 'Design options',
                        ),
                    )
                ),
            )
        );


		td_api_block::add( 'td_flex_block_1',
		    array(
		        'map_in_visual_composer' => false,
		        'map_in_td_composer'     => true,
		        "name"                   => 'Flex Block 1',
		        "base"                   => 'td_flex_block_1',
		        "class"                  => 'td_flex_block_1',
		        "controls"               => "full",
		        "category"               => 'Blocks',
		        'tdc_category'           => 'Blocks',
		        'icon'                   => 'icon-pagebuilder-td_flex_block_1',
		        'file'                   => TDC_PATH_LEGACY . '/includes/shortcodes/td_flex_block_1.php',
		        'tdc_style_params' => array(
		            'custom_title',
		            'custom_url',
		            'post_ids',
		            'category_id',
		            'category_ids',
		            'tag_slug',
		            'autors_id',
		            'installed_post_types',
		            'sort',
		            'td_ajax_filter_ids',
		            'td_filter_default_txt',
		            'td_ajax_preloading',
		            'ajax_pagination_infinite_stop',
		            'offset',
		            'modules_on_row',
		            'modules_gap',
		            'limit',
		            'el_class'
		        ),
		        'tdc_start_values'       => base64_encode(
		            json_encode(
		                array(
		                    array(
		                        "modules_on_row" => "33.33333333%",
		                        "limit" => '3',
		                        "hide_audio" => "yes"
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Font family',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Montserrat/Garamond
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "394",
		                        "f_ex_font_family" =>           "fs_4",
		                        "f_btn_font_family" =>          "fs_4",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Source Serif/Work Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
		                        'tdc_preset_individual' =>      '1',
		                        "f_title_font_family" =>        "721",
		                        "f_ex_font_family" =>           "653",
		                        "f_btn_font_family" =>          "653",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Raleway/Raleway
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "507",
		                        "f_ex_font_family" =>           "507",
		                        "f_btn_font_family" =>          "507",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Work Sans/Work Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "653",
		                        "f_ex_font_family" =>           "653",
		                        "f_btn_font_family" =>          "653",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Courgette/Open Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "147",
		                        "f_ex_font_family" =>           "",
		                        "f_btn_font_family" =>          "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Oswald/EB garamond
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "445",
		                        "f_ex_font_family" =>           "185",
		                        "f_btn_font_family" =>          "185",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Muli/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "406",
		                        "f_ex_font_family" =>           "406",
		                        "f_btn_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Wendy One/Josefin Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "646",
		                        "f_ex_font_family" =>           "297",
		                        "f_btn_font_family" =>          "297",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Anton/Roboto Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "41",
		                        "f_ex_font_family" =>           "523",
		                        "f_btn_font_family" =>          "523",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Quicksand/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "502",
		                        "f_ex_font_family" =>           "406",
		                        "f_btn_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Libre Baskerville/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "331",
		                        "f_ex_font_family" =>           "406",
		                        "f_btn_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Caveat/Josefin Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "663",
		                        "f_ex_font_family" =>           "297",
		                        "f_btn_font_family" =>          "297",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Volkorn/Montserrat
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "639",
		                        "f_ex_font_family" =>           "394",
		                        "f_btn_font_family" =>          "394",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Default
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "",
		                        "f_ex_font_family" =>           "",
		                        "f_btn_font_family" =>          "",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Font size',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XS 13/13/12/14
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
		                        "f_title_font_line_height" => "1.3",
		                        "f_ex_font_size" => "=",
		                        "f_ex_font_line_height" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - S 14/13/12/14
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
		                        "f_title_font_line_height" => "1.4",
		                        "f_ex_font_size" => "=",
		                        "f_ex_font_line_height" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - M 21/21/17/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIyMSIsImxhbmRzY2FwZSI6IjIwIiwicG9ydHJhaXQiOiIxNyJ9",
		                        "f_title_font_line_height" => "1.2",
		                        "f_ex_font_size" => "=",
		                        "f_ex_font_line_height" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - L 26/25/21/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIyNiIsImxhbmRzY2FwZSI6IjI1IiwicG9ydHJhaXQiOiIyMSIsInBob25lIjoiMjEifQ==",
		                        "f_title_font_line_height" => "1.2",
		                        "f_ex_font_size" => "eyJhbGwiOiIxNCIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_ex_font_line_height" => "1.5",

		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XL 30/28/24/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
		                        "f_title_font_line_height" => "1.2",
		                        "f_ex_font_size" => "eyJhbGwiOiIxNCIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_ex_font_line_height" => "1.5",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XXL 36/32/26/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
		                        "f_title_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
		                        "f_ex_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTQiLCJwaG9uZSI6IjEzIn0=",
		                        "f_ex_font_line_height" => "1.5",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Text alignment',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - left
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz" => "content-horiz-left",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - center
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz" => "content-horiz-center",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - right
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz" => "content-horiz-right",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Image format',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_image',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - OFF
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image1',
		                        'tdc_preset_individual' => '1',
		                        "hide_image" => "yes",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 2:3
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image2',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "150",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 3:4
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image3',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "133",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 7:8
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image4',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "114",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 1:1
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image5',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "100",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 5:4
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image6',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "80",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 4:3
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image7',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "75",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 3:2
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image8',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "67",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 16:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image9',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "56",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 18:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image10',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "50",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 21:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image11',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "40",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 30:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image12',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "30",
		                        "hide_image" => "",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Color library',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_color',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Color library
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color1',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#f9c100',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color2',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#ff7500',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color3',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#f44336',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color4',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#ff036e',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color5',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#58c7db',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color6',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#607d8b',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color7',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#005689',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color8',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#997df3',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color9',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#4caf50',
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Columns',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_col',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 1
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col1',
		                        'tdc_preset_individual' => '1',
		                        "modules_on_row" => "",
		                        "modules_gap" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 2
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col2',
		                        'tdc_preset_individual' => '1',
		                        "modules_on_row" => "eyJhbGwiOiI1MCUiLCJwaG9uZSI6IjEwMCUifQ==",
		                        "modules_gap" => "eyJhbGwiOiIxLjYlIiwicG9ydHJhaXQiOiIyJSJ9",
		                        "limit" => "2",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 3
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col3',
		                        'tdc_preset_individual' => '1',
		                        "modules_on_row" => "eyJhbGwiOiIzMy4zMzMzMzMzMyUiLCJwaG9uZSI6IjEwMCUifQ==",
		                        "modules_gap" => "1.4%",
		                        "limit" => "3",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 4
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col4',
		                        'tdc_preset_individual' => '1',
		                        "modules_on_row" => "eyJhbGwiOiIyNSUiLCJwaG9uZSI6IjUwJSJ9",
		                        "modules_gap" => "eyJhbGwiOiIxLjIlIiwicGhvbmUiOiIzJSJ9",
		                        "limit" => "4",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 5
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col5',
		                        'tdc_preset_individual' => '1',
		                        "modules_on_row" => "eyJhbGwiOiIyMCUiLCJwaG9uZSI6IjEwMCUifQ==",
		                        "modules_gap" => "1%",
		                        "limit" => "5",
		                        "image_width" => "eyJwaG9uZSI6IjMwIn0=",
		                        "image_floated" => "eyJwaG9uZSI6ImZsb2F0X2xlZnQifQ==",
		                        "meta_padding" => "eyJwaG9uZSI6IjJweCAwIDAgMTZweCJ9",
		                        "all_modules_space" => "eyJhbGwiOiIzNiIsInBob25lIjoiMjUifQ==",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Layout style',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_layout',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Layout style - normal
		                        'tdc_preset_class' => 'tdcp_img tdcp_layout tdcp_layout1',
		                        'tdc_preset_individual' => '1',
		                        "image_width" => "",
		                        "image_floated" => "",
		                        "meta_padding" => "",
		                        "image_radius" => "",
		                        "image_height" => "65",
		                        "meta_info_horiz" => "",
		                        "modules_category" => "image",
		                        "modules_category_margin" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Layout style - normal rounded
		                        'tdc_preset_class' => 'tdcp_img tdcp_layout tdcp_layout2',
		                        'tdc_preset_individual' => '1',
		                        "image_width" => "80",
		                        "image_floated" => "",
		                        "meta_padding" => "",
		                        "image_radius" => "500",
		                        "image_height" => "100",
		                        "meta_info_horiz" => "content-horiz-center",
		                        "modules_category" => "above",
		                        "modules_category_margin" => "0 0 8px 0",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Layout style - float left
		                        'tdc_preset_class' => 'tdcp_img tdcp_layout tdcp_layout3',
		                        'tdc_preset_individual' => '1',
		                        "image_width" => "30",
		                        "image_floated" => "float_left",
		                        "meta_padding" => "1% 5%",
		                        "image_radius" => "",
		                        "image_height" => "65",
		                        "meta_info_horiz" => "",
		                        "modules_category" => "image",
		                        "modules_category_margin" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Layout style - float left rounded
		                        'tdc_preset_class' => 'tdcp_img tdcp_layout tdcp_layout4',
		                        'tdc_preset_individual' => '1',
		                        "image_width" => "30",
		                        "image_floated" => "float_left",
		                        "meta_padding" => "1% 5%",
		                        "image_radius" => "500",
		                        "image_height" => "100",
		                        "meta_info_horiz" => "",
		                        "modules_category" => "",
		                        "modules_category_margin" => "",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Show/Hide module elements',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_elements',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_cat" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_cat" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Category tag', // Category tag
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_author" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_author" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Author', // Author
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_date" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_date" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Date', // Date
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_review" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_review" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Review stars', // Review
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_com" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_com" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Comment tag', // Comment tag
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h tdcp_clear',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Excerpt', // Excerpt
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_btn" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h tdcp_clear',
		                        'tdc_preset_individual' => '1',
		                        "show_btn" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Button', // Button
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                )
		            )
		        ),
		        "params"                 => array_merge(
		            self::get_map_block_general_array(),

		            array(
                        array(
                            "param_name" => "title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H4' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H3' => 'h3',
                                'Div' => 'div'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/title_seo.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Content length',
		                    "value"      => "",
		                    "class"      => "",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module Flex 1',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                ),
		                array(
		                    "param_name"  => "mc1_tl",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Title length',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
		                ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
		                array(
		                    "param_name"  => "mc1_el",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Excerpt length',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "25",
                            "info_img" => "https://cloud.tagdiv.com/help/excerpt_length.png",
		                ),
		            ),

		            self::get_map_filter_array(),
		            self::get_map_block_ajax_filter_array(),

		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Layout',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "container_width",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Container width (0-100 percent)',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "100",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_container.png",
		                ),
		                array(
		                    "param_name"  => "modules_on_row",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        '1'  => '100%',
		                        '2'  => '50%',
		                        '3'  => '33.33333333%',
		                        '4'  => '25%',
		                        '5'  => '20%',
		                        '6'  => '16.66666667%',
		                        '7'  => '14.28571428%',
		                        '8'  => '12.5%',
		                        '9'  => '11.11111111%',
		                        '10' => '10%',
		                    ),
		                    "heading"     => 'Modules per row',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-small",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
		                ),
		                array(
		                    "param_name"  => "modules_gap",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Modules gap',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "40",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
		                ),
		                array(
		                    "param_name"  => "m_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Modules padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
		                ),
		                array(
		                    "param_name"  => "all_modules_space",
		                    "type"        => "textfield-responsive",
		                    "value"       => '36',
		                    "heading"     => 'Modules bottom space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "36",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "modules_border_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
		                array(
		                    "param_name"  => "modules_divider",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'None'   => '',
		                        'Solid'  => 'solid',
		                        'Dotted' => 'dotted',
		                        'Dashed' => 'dashed',
		                    ),
		                    "heading"     => 'Modules divider',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_divider.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Modules divider color',
		                    "param_name"  => "modules_divider_color",
		                    "value"       => '#eaeaea',
		                    "description" => '',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_divider_color.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
		                array(
		                    "param_name"  => "h_effect",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'None'   => '',
		                        'Shadow'  => 'shadow',
		                        'Move up & shadow'  => 'up-shadow',
		                    ),
		                    "heading"     => 'Hover effect',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hover_effect.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article image',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "image_size",
		                    "type"        => "dropdown",
		                    "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
		                        'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
		                        '218x150px' => 'td_218x150',
		                        '324x400px'  => 'td_324x400',
		                        '485x360' => 'td_485x360'
		                    ),
		                    "heading"     => 'Image size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
		                ),
		                array(
		                    'param_name'  => 'image_alignment',
		                    'type'        => 'range-responsive',
		                    'value'       => '50',
		                    'heading'     => 'Image V alignment',
		                    'description' => '0 - Top / 50 - Center / 100 - Bottom',
		                    'class'       => 'tdc-textfield-small',
		                    'range_min'   => '0',
		                    'range_max'   => '100',
		                    'range_step'  => '1',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_v_alignment.png",
		                ),
		                array(
		                    "param_name"  => "image_height",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image height (percent)',
		                    "description" => "Default value in percent",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "50",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
		                ),
		                array(
		                    "param_name"  => "image_width",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image width (0-100 percent)',
		                    "description" => "Default value in percent",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "100",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
		                ),
		                array(
		                    "param_name"  => "image_floated",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Normal'      => 'no_float',
		                        'Float left'  => 'float_left',
		                        'Float right' => 'float_right',
		                        'Hidden'      => 'hidden',
		                    ),
		                    "heading"     => 'Image position',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_position.png",
		                ),
		                array(
		                    "param_name"  => "image_radius",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
		                ),
		                array(
		                    "param_name"  => "hide_image",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Hide image",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article video',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "video_icon",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video icon size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "video_popup",
                            "type"        => "checkbox",
                            "value"       => 'yes',
                            "heading"     => "Enable video pop-up",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_enable_video_pop-up.png",
                        ),
                        array(
                            "param_name" => "video_rec",
                            "type" => "textarea_raw_html",
                            "holder" => "div",
                            "class" => "tdc-textarea-raw-small",
                            "heading" => 'Video pop-up ad',
                            "value" => "",
                            "description" => 'Paste your ad code here.',
                            'group'      => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_popup_ad.png",
                        ),
                        array(
                            "param_name" => "spot_header",
                            "type" => "spot_header",
                            "value" => "",
                            "class" => '',
                            'group' => 'Layout',
                        ),
                        array(
                            "param_name" => "video_rec_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Ad title',
                            "description" => "",
                            "placeholder" => "- Advertisement -",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-spot-controller tdc-spot-title",
                            'group'      => 'Layout',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-spot-controller tdc-spot-color",
                            "heading"     => 'Ad title color',
                            "param_name"  => "video_rec_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "video_rec_disable",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Hide ADS for admins/editors",
                            "description" => "Used to prevent fake clicks and views on ads by admins and editors",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "show_vid_t",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show video duration',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_show_video_duration.png",
                        ),
                        array(
                            "param_name"  => "vid_t_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_space.png",
                        ),
                        array(
                            "param_name"  => "vid_t_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 4px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Video pop-up article title color',
                            "param_name"  => "video_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_title_color.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Video pop-up article title hover color',
                            "param_name"  => "video_title_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "video_bg",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Video pop-up background color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_background.png",
                        ),
                        array(
                            "param_name" => "video_overlay",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Video pop-up overlay color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_overlay_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name" => "vid_t_color",
                            "holder"     => "div",
                            "type"       => "colorpicker",
                            'heading'    => "Video duration text color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_text_color.png",
                        ),
                        array(
                            "param_name" => "vid_t_bg_color",
                            "holder"     => "div",
                            "type"       => "colorpicker",
                            'heading'    => "Video duration background color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_bg_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Layout',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_vid_title', true, 'Video pop-up article title', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_article_title.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_vid_time', false, 'Video duration text', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_duration_title.png', '' ),
                    self::get_map_exclusive_label_array(),
                    array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article meta info',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "meta_info_align",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Default' => '',
		                        'Top'     => 'initial',
		                        'Center'  => 'center',
		                        'Bottom'  => 'flex-end',
		                    ),
		                    "heading"     => 'Vertical align',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_vertical_align.png",
		                ),
		                array(
		                    "param_name" => "meta_info_horiz",
		                    "type" => "dropdown-responsive",
		                    "value" => array(
                                'Default' => 'layout-default',
		                        'Left' => 'content-horiz-left',
		                        'Center' => 'content-horiz-center',
		                        'Right' => 'content-horiz-right'
		                    ),
		                    "heading" => 'Horiz. align',
		                    "description" => "",
		                    "holder" => "div",
		                    'tdc_dropdown_images' => true,
		                    "class" => "tdc-visual-selector tdc-add-class",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
		                ),
		                array(
		                    "param_name"  => "meta_width",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "100%",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
		                ),
		                array(
		                    "param_name"  => "meta_margin",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info margin',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
		                ),
		                array(
		                    "param_name"  => "meta_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "13px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
		                ),
                        array(
                            "param_name"  => "meta_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta container space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_container_space.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article title',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "art_title",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Article title space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 6px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
		                ),
		                array(
		                    "param_name"  => "art_btn",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Article button space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "20px 0px 0px 0px",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Meta info border',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "meta_info_border_size",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_border_width.png",
		                ),
		                array(
		                    "param_name"  => "meta_info_border_style",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Solid'  => '',
		                        'Dotted' => 'dotted',
		                        'Dashed' => 'dashed',
		                    ),
		                    "heading"     => 'Border style',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_border_style_general.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Border color',
		                    "param_name"  => "meta_info_border_color",
		                    "value"       => '#eaeaea',
		                    "description" => '',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_border_color_general.png",
		                ),
                        array(
                            "param_name"  => "meta_info_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Category tag',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "modules_category",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Inline'      => '',
		                        'Above title' => 'above',
		                        'Over image'  => 'image',
		                    ),
		                    "heading"     => 'Category tag position',
		                    "description" => "Float image",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
		                ),
		                array(
		                    "param_name"  => "modules_category_margin",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category tag spacing',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_spacing.png",
		                ),
		                array(
		                    "param_name"  => "modules_category_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category tag padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "3px 6px 4px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
		                ),
		                array(
		                    "param_name"  => "modules_cat_border",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_border.png",
		                ),
		                array(
		                    'param_name'  => 'modules_category_radius',
		                    'type'        => 'range-responsive',
		                    'value'       => '0',
		                    'heading'     => 'Border radius',
		                    'description' => '',
		                    'class'       => 'tdc-textfield-small',
		                    'range_min'   => '0',
		                    'range_max'   => '100',
		                    'range_step'  => '1',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_radius.png",
		                ),
		                array(
		                    "param_name"  => "show_cat",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show category',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Author',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "show_author",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show author',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
		                ),
		                array(
		                    "param_name"  => "author_photo",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Show author photo",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_size",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "20",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_size.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_space",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "6",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_space.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_radius",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "50%",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_radius.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Date / Comment',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "show_date",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
                        ),
                        array(
                            "param_name"  => "show_com",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show comment',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review stars',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "show_review",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show review stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
                        ),
                        array(
                            "param_name"  => "review_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'review_size',
                            'type'        => 'range-responsive',
                            'value'       => '2.5',
                            'heading'     => 'Review stars size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name"  => "review_distance",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Distance between rating stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Excerpt',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Layout'
                        ),
		                array(
		                    "param_name"  => "show_excerpt",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show excerpt',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
		                ),
                        array(
                            "param_name"  => "art_excerpt",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article excerpt space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "20px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_excerpt_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "excerpt_col",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                '1'  => '1',
                                '2' => '2',
                                '3' => '3',
                            ),
                            "heading"     => 'Article excerpt columns',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-small",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_article_excerpt_columns.png",
                        ),
                        array(
                            "param_name"  => "excerpt_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article excerpt columns gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "48",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
		                array(
		                    "param_name"  => "excerpt_middle",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Excerpt in middle",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_excerpt_in_middle.png",
		                ),
		                array(
		                    "param_name"  => "excerpt_inline",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Inline Excerpt & Title",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_inline_excerpt_title.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article audio player',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_audio",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Visible' => 'block',
                                'Hidden' => 'none',
                            ),
                            "heading"     => 'Show audio player',
                            "description" => "This will hide the audio player responsive",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name"  => "hide_audio",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Remove audio player",
                            "description" => "This will remove the audio player from code",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "art_audio",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Audio player space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_space.png",
                        ),
                        array(
                            'param_name'  => 'art_audio_size',
                            'type'        => 'range-responsive',
                            'value'       => '1.5',
                            'heading'     => 'Audio player size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_size.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Button',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "show_btn",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show button',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_show.png",
		                ),
		                array(
		                    "param_name"  => "btn_title",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Button text',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "Read more",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_text.png",
		                ),
		                array(
		                    "param_name"  => "btn_margin",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Button space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 20px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_space.png",
		                ),
		                array(
		                    "param_name"  => "btn_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Button padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "10px 15px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_padding.png",
		                ),
		                array(
		                    "param_name"  => "btn_border_width",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Button border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_border.png",
		                ),
		                array(
		                    "param_name"  => "btn_radius",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Button border radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_radius.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Pagination',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name" => "pag_space",
		                    "type" => "textfield",
		                    "value" => '',
		                    "heading" => 'Top space',
		                    "description" => "",
		                    "placeholder" => "20",
		                    "holder" => "div",
		                    "class" => "tdc-textfield-small",
		                    'group'      => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_space.png",
		                ),
		                array(
		                    "param_name"  => "pag_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_padding.png",
		                ),
		                array(
		                    "param_name"  => "pag_border_width",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "1",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_border.png",
		                ),
		                array(
		                    "param_name"  => "pag_border_radius",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Border radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_border_radius.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group" => 'Layout',
		                ),
		                array(
		                    'param_name' => 'prev_tdicon',
		                    'type' => 'icon',
		                    'heading' => 'Prev icon',
		                    'class' => 'tdc-textfield-small',
		                    'value' => '',
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow.png",
		                ),
		                array(
		                    'param_name' => 'next_tdicon',
		                    'type' => 'icon',
		                    'heading' => 'Next icon',
		                    'class' => 'tdc-textfield-small',
		                    'value' => '',
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow.png",
		                ),
		                array(
		                    "param_name"  => "pag_icons_size",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Icons size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow_size.png",
		                ),

		                array(
		                    "param_name" => "separator",
		                    "type" => "text_separator",
		                    'heading' => 'Block fonts',
		                    "value" => "",
		                    "class" => "",
		                    "group" => 'Style',
		                ),
		            ),

		            td_config_helper::get_map_block_font_array( 'f_header', true, 'Block header', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_block_header.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_ajax', false, 'Ajax categories', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_ajax.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_more', false, 'Load more button', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_load_more.png', '' ),
		            array(
		                array(
		                    "param_name" => "separator",
		                    "type" => "text_separator",
		                    'heading' => 'Module fonts',
		                    "value" => "",
		                    "class" => "",
		                    "group" => 'Style',
		                ),
		            ),
		            td_config_helper::get_map_block_font_array( 'f_title', true, 'Article title', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_cat', false, 'Article category tag', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_meta', false, 'Article meta info', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_ex', false, 'Article excerpt', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_excerpt.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_btn', false, 'Article read more button', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_read.png', '' ),


                    td_config_helper::mix_blend(),
                    td_config_helper::image_filters(),


		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Colors',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Style",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Module background',
		                    "param_name"  => "m_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
		                ),
		                array(
		                    "param_name" => "color_overlay",
		                    "holder"     => "div",
		                    "type"       => "gradient",
		                    'heading'    => "Module image overlay",
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_overlay.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "horizontal_separator",
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		            ),
		            td_config_helper::get_map_block_shadow_array('shadow', 'Module Shadow', 0, 0, 0, "Style", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_shadow.png', '' ),
		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article title',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Article title text color',
		                    "param_name"  => "title_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_article_title.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Article title text hover',
		                    "param_name"  => "title_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name"  => "all_underline_height",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Underline size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/style_underline.png",
		                ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Hover underline color',
                            "param_name"  => "all_underline_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_underline_color.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Category tag',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category background',
		                    "param_name"  => "cat_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category background hover',
		                    "param_name"  => "cat_bg_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category text color',
		                    "param_name"  => "cat_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category text hover',
		                    "param_name"  => "cat_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category border color',
		                    "param_name"  => "cat_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_border.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category border hover',
		                    "param_name"  => "cat_border_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'AUTHOR / DATE / COMMENT / EXCERPT',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Meta info background',
		                    "param_name"  => "meta_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "horizontal_separator",
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Author text color',
		                    "param_name"  => "author_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Author text hover',
		                    "param_name"  => "author_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Date text color',
		                    "param_name"  => "date_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Excerpt text color',
		                    "param_name"  => "ex_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_excerpt.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Comment background',
		                    "param_name"  => "com_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Comment text color',
		                    "param_name"  => "com_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Review stars color',
		                    "param_name"  => "rev_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_color.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Audio player',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Buttons color',
                            "param_name"  => "audio_btn_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_buttons.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Time text color',
                            "param_name"  => "audio_time_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_time.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Bars background color',
                            "param_name"  => "audio_bar_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_bar.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Bars progress color',
                            "param_name"  => "audio_bar_curr_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_progress.png",
                        ),
		            ),
		            td_config_helper::get_map_block_shadow_array('shadow_m', 'Meta info shadow', 0, 0, 0, "Style", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_meta_shadow.png', '' ),
		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Button',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Button background',
		                    "param_name"  => "btn_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_color_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Button background hover',
		                    "param_name"  => "btn_bg_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Button text color',
		                    "param_name"  => "btn_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_color_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Button text hover',
		                    "param_name"  => "btn_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Button border color',
		                    "param_name"  => "btn_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_border_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Button border hover',
		                    "param_name"  => "btn_border_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Pagination',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Text color',
		                    "param_name"  => "pag_text",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_color_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Text hover color',
		                    "param_name"  => "pag_h_text",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Background color',
		                    "param_name"  => "pag_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_color_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Background hover color',
		                    "param_name"  => "pag_h_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Border color',
		                    "param_name"  => "pag_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_color_border.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Border hover color',
		                    "param_name"  => "pag_h_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		            ),
		            self::get_map_block_pagination_array()
		        )
		    )
		);

		td_api_block::add( 'td_flex_block_2',
		    array(
		        'map_in_visual_composer' => false,
		        'map_in_td_composer'     => true,
		        "name"                   => 'Flex Block 2',
		        "base"                   => 'td_flex_block_2',
		        "class"                  => 'td_flex_block_2',
		        "controls"               => "full",
		        "category"               => 'Blocks',
		        'tdc_category'           => 'Blocks',
		        'icon'                   => 'icon-pagebuilder-td_flex_block_2',
		        'file'                   => TDC_PATH_LEGACY . '/includes/shortcodes/td_flex_block_2.php',
		        'tdc_style_params' => array(
		            'custom_title',
		            'custom_url',
		            'post_ids',
		            'category_id',
		            'category_ids',
		            'tag_slug',
		            'autors_id',
		            'installed_post_types',
		            'sort',
		            'td_ajax_filter_ids',
		            'td_filter_default_txt',
		            'td_ajax_preloading',
		            'ajax_pagination_infinite_stop',
		            'offset',
		            'limit',
		            'el_class'
		        ),
		        'tdc_start_values'       => base64_encode(
		            json_encode(
		                array(
		                    array(
		                        'image_align' => 'center',
		                        'meta_info_align' => 'bottom',
		                        'color_overlay' => 'eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOltdLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApKTtiYWNrZ3JvdW5kOiBsaW5lYXItZ3JhZGllbnQoMGRlZyxyZ2JhKDAsMCwwLDAuNykscmdiYSgwLDAsMCwwKSk7IiwiY3NzUGFyYW1zIjoiMGRlZyxyZ2JhKDAsMCwwLDAuNykscmdiYSgwLDAsMCwwKSJ9',
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Font family',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Montserrat/Garamond
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "394",
		                        "f_ex_font_family" =>           "fs_4",
		                        "f_btn_font_family" =>          "fs_4",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Source Serif/Work Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
		                        'tdc_preset_individual' =>      '1',
		                        "f_title_font_family" =>        "721",
		                        "f_ex_font_family" =>           "653",
		                        "f_btn_font_family" =>          "653",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Raleway/Raleway
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "507",
		                        "f_ex_font_family" =>           "507",
		                        "f_btn_font_family" =>          "507",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Work Sans/Work Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "653",
		                        "f_ex_font_family" =>           "653",
		                        "f_btn_font_family" =>          "653",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Courgette/Open Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "147",
		                        "f_ex_font_family" =>           "",
		                        "f_btn_font_family" =>          "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Oswald/EB garamond
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "445",
		                        "f_ex_font_family" =>           "185",
		                        "f_btn_font_family" =>          "185",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Muli/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "406",
		                        "f_ex_font_family" =>           "406",
		                        "f_btn_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Wendy One/Josefin Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "646",
		                        "f_ex_font_family" =>           "297",
		                        "f_btn_font_family" =>          "297",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Anton/Roboto Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "41",
		                        "f_ex_font_family" =>           "523",
		                        "f_btn_font_family" =>          "523",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Quicksand/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "502",
		                        "f_ex_font_family" =>           "406",
		                        "f_btn_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Libre Baskerville/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "331",
		                        "f_ex_font_family" =>           "406",
		                        "f_btn_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Caveat/Josefin Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "663",
		                        "f_ex_font_family" =>           "297",
		                        "f_btn_font_family" =>          "297",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Volkorn/Montserrat
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "639",
		                        "f_ex_font_family" =>           "394",
		                        "f_btn_font_family" =>          "394",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Default
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "",
		                        "f_ex_font_family" =>           "",
		                        "f_btn_font_family" =>          "",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Font size',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XS 13/13/12/14
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
		                        "f_title_font_line_height" => "1.3",
		                        "f_ex_font_size" => "=",
		                        "f_ex_font_line_height" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - S 14/13/12/14
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
		                        "f_title_font_line_height" => "1.4",
		                        "f_ex_font_size" => "=",
		                        "f_ex_font_line_height" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - M 21/21/17/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIyMSIsImxhbmRzY2FwZSI6IjIwIiwicG9ydHJhaXQiOiIxNyJ9",
		                        "f_title_font_line_height" => "1.2",
		                        "f_ex_font_size" => "=",
		                        "f_ex_font_line_height" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - L 26/25/21/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIyNiIsImxhbmRzY2FwZSI6IjI1IiwicG9ydHJhaXQiOiIyMSIsInBob25lIjoiMjEifQ==",
		                        "f_title_font_line_height" => "1.2",
		                        "f_ex_font_size" => "eyJhbGwiOiIxNCIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_ex_font_line_height" => "1.5",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XL 30/28/24/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
		                        "f_title_font_line_height" => "1.2",
		                        "f_ex_font_size" => "eyJhbGwiOiIxNCIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_ex_font_line_height" => "1.5",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XXL 36/32/26/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
		                        "f_title_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
		                        "f_ex_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTQiLCJwaG9uZSI6IjEzIn0=",
		                        "f_ex_font_line_height" => "1.5",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Text alignment',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - left
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz" => "content-horiz-left",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - center
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz" => "content-horiz-center",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - right
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz" => "content-horiz-right",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Color library',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_color',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Color library
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color1',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#f9c100',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color2',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#ff7500',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color3',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#f44336',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color4',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#ff036e',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color5',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#58c7db',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color6',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#607d8b',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color7',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#005689',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color8',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#997df3',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color9',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#4caf50',
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Layout style',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_layout',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Layout style - normal
		                        'tdc_preset_class' => 'tdcp_img tdcp_layout tdcp_layout7',
		                        'tdc_preset_individual' => '1',
		                        "image_margin_right" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Layout style - normal
		                        'tdc_preset_class' => 'tdcp_img tdcp_layout tdcp_layout8',
		                        'tdc_preset_individual' => '1',
		                        "image_margin_right" => "yes",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Show/Hide module elements',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_elements',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_cat" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_cat" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Category tag', // Category tag
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_author" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_author" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Author', // Author
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_date" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_date" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Date', // Date
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_review" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_review" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Review stars', // Review
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_com" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_com" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Comment tag', // Comment tag
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h tdcp_clear',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Excerpt', // Excerpt
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                )
		            )
		        ),
		        "params"                 => array_merge(
		            self::get_map_block_general_array(),

		            array(
                        array(
                            "param_name" => "title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H4' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H3' => 'h3',
                                'Div' => 'div'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/title_seo.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Content length',
		                    "value"      => "",
		                    "class"      => "",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module Flex 2',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                ),
		                array(
		                    "param_name"  => "mc2_tl",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Title length',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
		                ),
                        array(
                            "param_name" => "mc2_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
		                array(
		                    "param_name"  => "mc2_el",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Excerpt length',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "25",
                            "info_img" => "https://cloud.tagdiv.com/help/excerpt_length.png",
		                ),
		            ),

		            self::get_map_filter_array(),
		            self::get_map_block_ajax_filter_array(),

		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Layout',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "modules_height",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Modules height',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "460",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "modules_space",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Modules bottom space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "36",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "horizontal_separator",
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "block_title_over",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Block title over image",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "block_title_space",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Block title space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "horizontal_separator",
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name" => "nextprev_position",
		                    "type"       => "dropdown-responsive",
		                    "value"      => array(
		                        'Top'    => 'top',
		                        'Botom'  => 'bottom',
		                    ),
		                    "heading"     => 'Next Prev position',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "nextprev",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Next prev space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "20px 20px 0px 0px",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article image',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "image_size",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Full - Default - 1920x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Medium - 696x0px'  => 'td_696x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                '-- [Other sizes] --' => '__',
                                '218x150' => 'td_218x150px',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
		                    ),
		                    "heading"     => 'Image size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
		                ),
		                array(
		                    'param_name'  => 'image_alignment',
		                    'type'        => 'range-responsive',
		                    'value'       => '50',
		                    'heading'     => 'Image V alignment',
		                    'description' => '0 - Top / 50 - Center / 100 - Bottom',
		                    'class'       => 'tdc-textfield-small',
		                    'range_min'   => '0',
		                    'range_max'   => '100',
		                    'range_step'  => '1',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_v_alignment.png",
		                ),
		                array(
		                    "param_name"  => "image_radius",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "horizontal_separator",
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "image_margin",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image negative margin',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "100",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_margin.png",
		                ),
		                array(
		                    "param_name"  => "image_margin_right",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Reverse negative margin",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "image_margin_forced",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Auto stretch image",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout'
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article video',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "video_icon",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video icon size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name"  => "video_icon_pos",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Center'  => 'center',
                                'Corner' => 'corner',
                            ),
                            "heading"     => 'Video icon position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "video_popup",
                            "type"        => "checkbox",
                            "value"       => 'yes',
                            "heading"     => "Enable video pop-up",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_enable_video_pop-up.png",
                        ),
                        array(
                            "param_name" => "video_rec",
                            "type" => "textarea_raw_html",
                            "holder" => "div",
                            "class" => "tdc-textarea-raw-small",
                            "heading" => 'Video pop-up ad',
                            "value" => "",
                            "description" => 'Paste your ad code here.',
                            'group'      => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_popup_ad.png",
                        ),
                        array(
                            "param_name" => "spot_header",
                            "type" => "spot_header",
                            "value" => "",
                            "class" => '',
                            'group' => 'Layout',
                        ),
                        array(
                            "param_name" => "video_rec_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Ad title',
                            "description" => "",
                            "placeholder" => "- Advertisement -",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-spot-controller tdc-spot-title",
                            'group'      => 'Layout',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-spot-controller tdc-spot-color",
                            "heading"     => 'Ad title color',
                            "param_name"  => "video_rec_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "video_rec_disable",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Hide ADS for admins/editors",
                            "description" => "Used to prevent fake clicks and views on ads by admins and editors",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "show_vid_t",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show video duration',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_show_video_duration.png",
                        ),
                        array(
                            "param_name"  => "vid_t_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0 5px 0 0",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_space.png",
                        ),
                        array(
                            "param_name"  => "vid_t_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 4px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Video pop-up article title color',
                            "param_name"  => "video_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_title_color.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Video pop-up article title hover color',
                            "param_name"  => "video_title_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "video_bg",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Video pop-up background color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_background.png",
                        ),
                        array(
                            "param_name" => "video_overlay",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Video pop-up overlay color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_overlay_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name" => "vid_t_color",
                            "holder"     => "div",
                            "type"       => "colorpicker",
                            'heading'    => "Video duration text color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_text_color.png",
                        ),
                        array(
                            "param_name" => "vid_t_bg_color",
                            "holder"     => "div",
                            "type"       => "colorpicker",
                            'heading'    => "Video duration background color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_bg_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Layout',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_vid_title', true, 'Video pop-up article title', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_article_title.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_vid_time', false, 'Video duration text', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_duration_title.png', '' ),
                    self::get_map_exclusive_label_array(),
                    array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article meta info',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "meta_info_align",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Top'     => 'top',
		                        'Center'  => 'center',
		                        'Bottom'  => 'bottom',
		                    ),
		                    "heading"     => 'Meta info alignment',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_vertical_align.png",
		                ),
		                array(
		                    "param_name" => "meta_info_horiz",
		                    "type" => "dropdown",
		                    "value" => array(
		                        'Left' => 'content-horiz-left',
		                        'Center' => 'content-horiz-center',
		                        'Right' => 'content-horiz-right'
		                    ),
		                    "heading" => 'Meta info horiz align',
		                    "description" => "",
		                    "holder" => "div",
		                    'tdc_dropdown_images' => true,
		                    "class" => "tdc-visual-selector tdc-add-class",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
		                ),
		                array(
		                    "param_name"  => "meta_width",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "100%",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
		                ),
		                array(
		                    "param_name"  => "meta_margin",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info margin',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
		                ),
		                array(
		                    "param_name"  => "meta_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 40px 40px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
		                ),
                        array(
                            "param_name"  => "meta_info_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
		                array(
		                    "param_name"  => "art_title",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Article title space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 8px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Category tag',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
                        ),
                        array(
                            "param_name"  => "modules_category_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_spacing.png",
                        ),
                        array(
                            "param_name"  => "modules_category_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 4px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
                        ),
                        array(
                            "param_name"  => "modules_cat_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_border.png",
                        ),
                        array(
                            'param_name'  => 'modules_category_radius',
                            'type'        => 'range-responsive',
                            'value'       => '0',
                            'heading'     => 'Border radius',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_radius.png",
                        ),
                        array(
                            "param_name"  => "show_cat",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Author / date / comment',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
                        ),
                        array(
                            "param_name"  => "show_date",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
                        ),
                        array(
                            "param_name"  => "show_com",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show comment',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review stars',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_review",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show review stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
                        ),
                        array(
                            "param_name"  => "review_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'review_size',
                            'type'        => 'range-responsive',
                            'value'       => '2.5',
                            'heading'     => 'Review stars size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name"  => "review_distance",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Distance between rating stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Excerpt',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_excerpt",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show excerpt',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
                        ),
		                array(
		                    "param_name"  => "art_excerpt",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Article excerpt space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "18px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_excerpt_space.png",
		                ),
		                array(
		                    "param_name"  => "excerpt_middle",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Excerpt in middle",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_excerpt_in_middle.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Pagination',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "pag_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_padding.png",
		                ),
		                array(
		                    "param_name"  => "pag_border_width",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "1",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_border.png",
		                ),
		                array(
		                    "param_name"  => "pag_border_radius",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Border radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_border_radius.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group" => 'Layout',
		                ),
		                array(
		                    'param_name' => 'prev_tdicon',
		                    'type' => 'icon',
		                    'heading' => 'Prev icon',
		                    'class' => 'tdc-textfield-small',
		                    'value' => '',
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow.png",
		                ),
		                array(
		                    'param_name' => 'next_tdicon',
		                    'type' => 'icon',
		                    'heading' => 'Next icon',
		                    'class' => 'tdc-textfield-small',
		                    'value' => '',
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow.png",
		                ),
		                array(
		                    "param_name"  => "pag_icons_size",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Icons size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow_size.png",
		                ),
		            ),


		            array(
		                array(
		                    "param_name" => "separator",
		                    "type" => "text_separator",
		                    'heading' => 'Block fonts',
		                    "value" => "",
		                    "class" => "",
		                    "group" => 'Style',
		                ),
		            ),
		            td_config_helper::get_map_block_font_array( 'f_header', true, 'Block header', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_block_header.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_ajax', false, 'Ajax categories', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_ajax.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_more', false, 'Load more button', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_load_more.png', '' ),
		            array(
		                array(
		                    "param_name" => "separator",
		                    "type" => "text_separator",
		                    'heading' => 'Module fonts',
		                    "value" => "",
		                    "class" => "",
		                    "group" => 'Style',
		                ),
		            ),
		            td_config_helper::get_map_block_font_array( 'f_title', true, 'Article title', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_cat', false, 'Article category tag', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_meta', false, 'Article meta info', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_ex', false, 'Article excerpt', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_excerpt.png', '' ),

                    td_config_helper::mix_blend(),
                    td_config_helper::image_filters(),

		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Colors',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Style",
		                ),
		                array(
		                    "param_name" => "color_overlay",
		                    "holder"     => "div",
		                    "type"       => "gradient",
		                    'heading'    => "Module image overlay",
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_overlay.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Meta info background',
		                    "param_name"  => "meta_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "horizontal_separator",
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"      => "Style",
		                ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Next Prev arrows color',
                            "param_name"  => "nextprev_icon",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Next Prev hover arrows color',
                            "param_name"  => "nextprev_icon_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Next Prev background',
                            "param_name"  => "nextprev_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Next Prev hover background',
                            "param_name"  => "nextprev_bg_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "horizontal_separator",
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"      => "Style",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Article title text color',
		                    "param_name"  => "title_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_article_title.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Article title text hover',
		                    "param_name"  => "title_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name"  => "all_underline_height",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Underline size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/style_underline.png",
		                ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Hover underline color',
                            "param_name"  => "all_underline_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_underline_color.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "horizontal_separator",
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"      => "Style",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category background',
		                    "param_name"  => "cat_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category background hover',
		                    "param_name"  => "cat_bg_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category text color',
		                    "param_name"  => "cat_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category text hover',
		                    "param_name"  => "cat_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category border color',
		                    "param_name"  => "cat_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_border.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category border hover',
		                    "param_name"  => "cat_border_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "horizontal_separator",
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"      => "Style",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Author text color',
		                    "param_name"  => "author_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Author text hover',
		                    "param_name"  => "author_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Date text color',
		                    "param_name"  => "date_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Excerpt text color',
		                    "param_name"  => "ex_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_excerpt.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Comment text color',
		                    "param_name"  => "com_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Comment icon color',
		                    "param_name"  => "com_icon",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		            ),

		            self::get_map_block_pagination_array()
		        )
		    )
		);

		td_api_block::add( 'td_flex_block_3',
		    array(
		        'map_in_visual_composer' => false,
		        'map_in_td_composer'     => true,
		        "name"                   => 'Flex Block 3',
		        "base"                   => 'td_flex_block_3',
		        "class"                  => 'td_flex_block_3',
		        "controls"               => "full",
		        "category"               => 'Blocks',
		        'tdc_category'           => 'Blocks',
		        'icon'                   => 'icon-pagebuilder-td_flex_block_3',
		        'file'                   => TDC_PATH_LEGACY . '/includes/shortcodes/td_flex_block_3.php',
		        'tdc_style_params' => array(
		            'custom_title',
		            'custom_url',
		            'post_ids',
		            'category_id',
		            'category_ids',
		            'tag_slug',
		            'autors_id',
		            'installed_post_types',
		            'sort',
		            'td_ajax_filter_ids',
		            'td_filter_default_txt',
		            'td_ajax_preloading',
		            'ajax_pagination_infinite_stop',
		            'offset',
		            'columns',
		            'columns_gap',
		            'limit',
		            'el_class'
		        ),
		        'tdc_start_values'       => base64_encode(
		            json_encode(
		                array(
		                    array(
		                        "modules_category" => "image",
		                        "modules_on_row" => "eyJhbGwiOiI1MCUiLCJsYW5kc2NhcGUiOiIxMDAlIn0=",
		                        "modules_category1" => "image",
		                        "show_cat2" => "none",
		                        "show_com2" => "none",
		                        "show_author2" => "none",
		                        "columns" => "eyJhbGwiOiI1MCUiLCJwaG9uZSI6IjEwMCUifQ==",
		                        "columns_gap" => "eyJsYW5kc2NhcGUiOiI0MCIsInBvcnRyYWl0IjoiMjgifQ==",
		                        "image_width2" => "eyJwb3J0cmFpdCI6IjM1In0=",
		                        "modules_space1" => "eyJhbGwiOiIwIiwicGhvbmUiOiIyMSJ9",
                                "hide_audio" => "yes",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Font family',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Montserrat/Garamond
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "394",
		                        "f_ex1_font_family" =>           "fs_4",
		                        "f_btn1_font_family" =>          "fs_4",
		                        "f_title2_font_family" =>        "394",
		                        "f_ex2_font_family" =>           "fs_4",
		                        "f_btn2_font_family" =>          "fs_4",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Source Serif/Work Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
		                        'tdc_preset_individual' =>      '1',
		                        "f_title1_font_family" =>        "721",
		                        "f_ex1_font_family" =>           "653",
		                        "f_btn1_font_family" =>          "653",
		                        "f_title2_font_family" =>        "721",
		                        "f_ex2_font_family" =>           "653",
		                        "f_btn2_font_family" =>          "653",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Raleway/Raleway
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "507",
		                        "f_ex1_font_family" =>           "507",
		                        "f_btn1_font_family" =>          "507",
		                        "f_title2_font_family" =>        "507",
		                        "f_ex2_font_family" =>           "507",
		                        "f_btn2_font_family" =>          "507",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Work Sans/Work Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "653",
		                        "f_ex1_font_family" =>           "653",
		                        "f_btn1_font_family" =>          "653",
		                        "f_title2_font_family" =>        "653",
		                        "f_ex2_font_family" =>           "653",
		                        "f_btn2_font_family" =>          "653",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Courgette/Open Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "147",
		                        "f_ex1_font_family" =>           "",
		                        "f_btn1_font_family" =>          "",
		                        "f_title2_font_family" =>        "147",
		                        "f_ex2_font_family" =>           "",
		                        "f_btn2_font_family" =>          "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Oswald/EB garamond
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "445",
		                        "f_ex1_font_family" =>           "185",
		                        "f_btn1_font_family" =>          "185",
		                        "f_title2_font_family" =>        "445",
		                        "f_ex2_font_family" =>           "185",
		                        "f_btn2_font_family" =>          "185",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Muli/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "406",
		                        "f_ex1_font_family" =>           "406",
		                        "f_btn1_font_family" =>          "406",
		                        "f_title2_font_family" =>        "406",
		                        "f_ex2_font_family" =>           "406",
		                        "f_btn2_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Wendy One/Josefin Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "646",
		                        "f_ex1_font_family" =>           "297",
		                        "f_btn1_font_family" =>          "297",
		                        "f_title2_font_family" =>        "646",
		                        "f_ex2_font_family" =>           "297",
		                        "f_btn2_font_family" =>          "297",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Anton/Roboto Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "41",
		                        "f_ex1_font_family" =>           "523",
		                        "f_btn1_font_family" =>          "523",
		                        "f_title2_font_family" =>        "41",
		                        "f_ex2_font_family" =>           "523",
		                        "f_btn2_font_family" =>          "523",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Quicksand/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "502",
		                        "f_ex1_font_family" =>           "406",
		                        "f_btn1_font_family" =>          "406",
		                        "f_title2_font_family" =>        "502",
		                        "f_ex2_font_family" =>           "406",
		                        "f_btn2_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Libre Baskerville/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "331",
		                        "f_ex1_font_family" =>           "406",
		                        "f_btn1_font_family" =>          "406",
		                        "f_title2_font_family" =>        "331",
		                        "f_ex2_font_family" =>           "406",
		                        "f_btn2_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Caveat/Josefin Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "663",
		                        "f_ex1_font_family" =>           "297",
		                        "f_btn1_font_family" =>          "297",
		                        "f_title2_font_family" =>        "663",
		                        "f_ex2_font_family" =>           "297",
		                        "f_btn2_font_family" =>          "297",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Volkorn/Montserrat
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "639",
		                        "f_ex1_font_family" =>           "394",
		                        "f_btn1_font_family" =>          "394",
		                        "f_title2_font_family" =>        "639",
		                        "f_ex2_font_family" =>           "394",
		                        "f_btn2_font_family" =>          "394",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Default
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "",
		                        "f_ex1_font_family" =>           "",
		                        "f_btn1_font_family" =>          "",
		                        "f_title2_font_family" =>        "",
		                        "f_ex2_font_family" =>           "",
		                        "f_btn2_font_family" =>          "",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Font size',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XS 13/13/12/14
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
		                        "f_title1_font_line_height" => "1.3",
		                        "f_ex1_font_size" => "",
		                        "f_ex1_font_line_height" => "",
		                        "f_title2_font_size" => "eyJhbGwiOiIxMiIsInBvcnRyYWl0IjoiMTEiLCJwaG9uZSI6IjEzIn0=",
		                        "f_title2_font_line_height" => "1.3",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - S 14/13/12/14
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
		                        "f_title1_font_line_height" => "1.4",
		                        "f_ex1_font_size" => "",
		                        "f_ex1_font_line_height" => "",
		                        "f_title2_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIifQ==",
		                        "f_title2_font_line_height" => "eyJwaG9uZSI6IjEuMyIsImFsbCI6IjEuNCJ9",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - M 21/21/17/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_size" => "eyJhbGwiOiIyMSIsImxhbmRzY2FwZSI6IjIwIiwicG9ydHJhaXQiOiIxNyJ9",
		                        "f_title1_font_line_height" => "1.2",
		                        "f_ex1_font_size" => "",
		                        "f_ex1_font_line_height" => "",
		                        "f_title2_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_title2_font_line_height" => "1.4",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - L 26/25/21/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_size" => "eyJhbGwiOiIyNiIsImxhbmRzY2FwZSI6IjI1IiwicG9ydHJhaXQiOiIyMSIsInBob25lIjoiMjEifQ==",
		                        "f_title1_font_line_height" => "1.2",
		                        "f_ex1_font_size" => "eyJhbGwiOiIxNCIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_ex1_font_line_height" => "1.5",
		                        "f_title2_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_title2_font_line_height" => "1.4",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XL 30/28/24/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
		                        "f_title1_font_line_height" => "1.2",
		                        "f_title2_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_title2_font_line_height" => "1.4",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XXL 36/32/26/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
		                        "f_title1_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
		                        "f_ex1_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTQiLCJwaG9uZSI6IjEzIn0=",
		                        "f_ex1_font_line_height" => "1.5",
		                        "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQiLCJwaG9uZSI6IjE0IiwibGFuZHNjYXBlIjoiMTUifQ==",
		                        "f_title2_font_line_height" => "1.4",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Text alignment',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - left
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz1" => "content-horiz-left",
		                        "meta_info_horiz2" => "content-horiz-left",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - center
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz1" => "content-horiz-center",
		                        "meta_info_horiz2" => "content-horiz-center",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - right
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz1" => "content-horiz-right",
		                        "meta_info_horiz2" => "content-horiz-right",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Image format',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_image',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - OFF
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image1',
		                        'tdc_preset_individual' => '1',
		                        "hide_image" => "yes",
		                        "hide_image2" => "yes",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 2:3
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image2',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "150",
		                        "image_height2" => "150",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 3:4
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image3',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "133",
		                        "image_height2" => "133",
		                        "hide_image" => "",
		                        "hide_image1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 7:8
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image4',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "114",
		                        "image_height2" => "114",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 1:1
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image5',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "100",
		                        "image_height2" => "100",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 5:4
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image6',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "80",
		                        "image_height2" => "80",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 4:3
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image7',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "75",
		                        "image_height2" => "75",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 3:2
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image8',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "67",
		                        "image_height2" => "67",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 16:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image9',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "56",
		                        "image_height2" => "56",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 18:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image10',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "50",
		                        "image_height2" => "50",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 21:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image11',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "40",
		                        "image_height2" => "40",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 30:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image12',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "30",
		                        "image_height2" => "30",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Color library',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_color',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Color library
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color1',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#f9c100',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color2',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#ff7500',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color3',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#f44336',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color4',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#ff036e',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color5',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#58c7db',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color6',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#607d8b',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color7',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#005689',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color8',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#997df3',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color9',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#4caf50',
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Columns',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_col',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 1
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col1',
		                        'tdc_preset_individual' => '1',
		                        "columns" => "",
		                        "modules_gap" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 2
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col2',
		                        'tdc_preset_individual' => '1',
		                        "columns" => "eyJhbGwiOiI1MCUiLCJwaG9uZSI6IjEwMCUifQ==",
		                        "columns_gap" => "eyJhbGwiOiI0OCIsInBvcnRyYWl0IjoiMjgiLCJsYW5kc2NhcGUiOiI0MCJ9",
		                        "limit" => "5",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 3
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col3',
		                        'tdc_preset_individual' => '1',
		                        "columns" => "eyJhbGwiOiIzMy4zMzMzMzMzMyUiLCJwaG9uZSI6IjEwMCUifQ==",
		                        "columns_gap" => "eyJhbGwiOiI0OCIsInBvcnRyYWl0IjoiMjgiLCJsYW5kc2NhcGUiOiI0MCJ9",
		                        "limit" => "9",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Show/Hide module elements',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_elements',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_cat1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_cat1" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s tdcp_elements_s_small',
		                        'tdc_preset_individual' => '1',
		                        "show_cat2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_cat2" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Category tag', // Category tag
		                        'tdc_preset_class' => 'tdcp_elements_text tdcp_elements_text_small',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_author1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_author1" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s tdcp_elements_s_small',
		                        'tdc_preset_individual' => '1',
		                        "show_author2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_author2" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Author', // Author
		                        'tdc_preset_class' => 'tdcp_elements_text tdcp_elements_text_small',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_date1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_date1" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s tdcp_elements_s_small',
		                        'tdc_preset_individual' => '1',
		                        "show_date2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_date2" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Date', // Date
		                        'tdc_preset_class' => 'tdcp_elements_text tdcp_elements_text_small',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_review1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_review1" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s tdcp_elements_s_small',
		                        'tdc_preset_individual' => '1',
		                        "show_review2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_review2" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Review stars', // Review
		                        'tdc_preset_class' => 'tdcp_elements_text tdcp_elements_text_small',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_com1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_com1" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s tdcp_elements_s_small',
		                        'tdc_preset_individual' => '1',
		                        "show_com2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_com2" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Comment tag', // Comment tag
		                        'tdc_preset_class' => 'tdcp_elements_text tdcp_elements_text_small',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h tdcp_clear',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt1" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_disabled tdcp_elements_s tdcp_elements_s_small',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_disabled tdcp_elements_h tdcp_clear',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt2" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Excerpt', // Excerpt
		                        'tdc_preset_class' => 'tdcp_elements_text tdcp_elements_text_small',
		                    ),
		                )
		            )
		        ),
		        "params"                 => array_merge(
		            self::get_map_block_general_array(),

		            array(
                        array(
                            "param_name" => "title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H4' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H3' => 'h3',
                                'Div' => 'div'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/title_seo.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Content length',
		                    "value"      => "",
		                    "class"      => "",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module Flex 1',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                ),
		                array(
		                    "param_name"  => "mc1_tl",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Title length',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
		                ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
		                array(
		                    "param_name"  => "mc1_el",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Excerpt length',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "25",
                            "info_img" => "https://cloud.tagdiv.com/help/excerpt_length.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module Flex 3',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                ),
		                array(
		                    "param_name"  => "mc3_tl",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Title length',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
		                ),
                        array(
                            "param_name" => "mc3_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
		            ),

		            self::get_map_filter_array(),
		            self::get_map_block_ajax_filter_array(),

		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Layout',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "columns",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        '1'  => '100%',
		                        '2'  => '50%',
		                        '3'  => '33.33333333%',
		                    ),
		                    "heading"     => 'Columns',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-small",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "columns_gap",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Columns gap',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "48",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "h_effect",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'None'   => '',
		                        'Shadow'  => 'shadow',
		                        'Move up & shadow'  => 'up-shadow',
		                    ),
		                    "heading"     => 'Hover effect',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hover_effect.png",
		                ),


		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module 1',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "modules_space1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '0',
		                    "heading"     => 'Modules bottom space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "modules_border_size1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style1",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color1",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
		                array(
		                    "param_name"  => "modules_divider1",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'None'   => '',
		                        'Solid'  => 'solid',
		                        'Dotted' => 'dotted',
		                        'Dashed' => 'dashed',
		                    ),
		                    "heading"     => 'Module divider',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_divider.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Module divider color',
		                    "param_name"  => "modules_divider_color1",
		                    "value"       => '#eaeaea',
		                    "description" => '',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_divider_color.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article image',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "image_size",
		                    "type"        => "dropdown",
		                    "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
		                    ),
		                    "heading"     => 'Image size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
		                ),
		                array(
		                    'param_name'  => 'image_alignment1',
		                    'type'        => 'range-responsive',
		                    'value'       => '50',
		                    'heading'     => 'Image V alignment',
		                    'description' => '0 - Top / 50 - Center / 100 - Bottom',
		                    'class'       => 'tdc-textfield-small',
		                    'range_min'   => '0',
		                    'range_max'   => '100',
		                    'range_step'  => '1',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_v_alignment.png",
		                ),
		                array(
		                    "param_name"  => "image_height1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image height (percent)',
		                    "description" => "Default value in percent",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "72",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
		                ),
		                array(
		                    "param_name"  => "image_radius1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
		                ),
		                array(
		                    "param_name"  => "hide_image",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Hide image",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article video',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "video_icon1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video icon size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "video_popup",
                            "type"        => "checkbox",
                            "value"       => 'yes',
                            "heading"     => "Enable video pop-up",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_enable_video_pop-up.png",
                        ),
                        array(
                            "param_name" => "video_rec",
                            "type" => "textarea_raw_html",
                            "holder" => "div",
                            "class" => "tdc-textarea-raw-small",
                            "heading" => 'Video pop-up ad',
                            "value" => "",
                            "description" => 'Paste your ad code here.',
                            'group'      => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_popup_ad.png",
                        ),
                        array(
                            "param_name" => "spot_header",
                            "type" => "spot_header",
                            "value" => "",
                            "class" => '',
                            'group' => 'Layout',
                        ),
                        array(
                            "param_name" => "video_rec_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Ad title',
                            "description" => "",
                            "placeholder" => "- Advertisement -",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-spot-controller tdc-spot-title",
                            'group'      => 'Layout',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-spot-controller tdc-spot-color",
                            "heading"     => 'Ad title color',
                            "param_name"  => "video_rec_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "video_rec_disable",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Hide ADS for admins/editors",
                            "description" => "Used to prevent fake clicks and views on ads by admins and editors",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "show_vid_t",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show video duration',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_show_video_duration.png",
                        ),
                        array(
                            "param_name"  => "vid_t_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_space.png",
                        ),
                        array(
                            "param_name"  => "vid_t_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 4px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Video pop-up article title color',
                            "param_name"  => "video_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_title_color.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Video pop-up article title hover color',
                            "param_name"  => "video_title_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "video_bg",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Video pop-up background color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_background.png",
                        ),
                        array(
                            "param_name" => "video_overlay",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Video pop-up overlay color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_overlay_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name" => "vid_t_color",
                            "holder"     => "div",
                            "type"       => "colorpicker",
                            'heading'    => "Video duration text color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_text_color.png",
                        ),
                        array(
                            "param_name" => "vid_t_bg_color",
                            "holder"     => "div",
                            "type"       => "colorpicker",
                            'heading'    => "Video duration background color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_bg_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Layout',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_vid_title', true, 'Video pop-up article title', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_article_title.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_vid_time', false, 'Video duration text', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_duration_title.png', '' ),
                    self::get_map_exclusive_label_array('1', true),
                    array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article meta info',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "meta_info_align1",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Bottom' => '',
		                        'Top'     => 'initial',
		                    ),
		                    "heading"     => 'Meta info alignment',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_vertical_align.png",
		                ),
		                array(
		                    "param_name" => "meta_info_horiz1",
		                    "type" => "dropdown",
		                    "value" => array(
		                        'Left' => 'content-horiz-left',
		                        'Center' => 'content-horiz-center',
		                        'Right' => 'content-horiz-right'
		                    ),
		                    "heading" => 'Meta info horiz align',
		                    "description" => "",
		                    "holder" => "div",
		                    'tdc_dropdown_images' => true,
		                    "class" => "tdc-visual-selector tdc-add-class",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
		                ),
		                array(
		                    "param_name"  => "meta_width1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "100%",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
		                ),
		                array(
		                    "param_name"  => "meta_margin1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info margin',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
		                ),
		                array(
		                    "param_name"  => "meta_padding1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "13px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
		                ),
                        array(
                            "param_name"  => "meta_info_border_radius1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "art_title1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Article title space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 6px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
		                array(
		                    "param_name"  => "modules_category",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Inline'      => '',
		                        'Above title' => 'above',
		                        'Over image'  => 'image',
		                    ),
		                    "heading"     => 'Category tag position',
		                    "description" => "Float image",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
		                ),
		                array(
		                    "param_name"  => "modules_category_margin1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category tag spacing',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_spacing.png",
		                ),
		                array(
		                    "param_name"  => "modules_category_padding1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category tag padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "3px 6px 4px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
		                ),
		                array(
		                    "param_name"  => "modules_cat_border1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_border.png",
		                ),
		                array(
		                    'param_name'  => 'modules_category_radius1',
		                    'type'        => 'range-responsive',
		                    'value'       => '0',
		                    'heading'     => 'Category tag border radius',
		                    'description' => '',
		                    'class'       => 'tdc-textfield-small',
		                    'range_min'   => '0',
		                    'range_max'   => '100',
		                    'range_step'  => '1',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_radius.png",
		                ),
		                array(
		                    "param_name"  => "show_cat1",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show category tag',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "show_author1",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show author',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
		                ),
		                array(
		                    "param_name"  => "author_photo",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Show author photo",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_size1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "20",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_size.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_space1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "6",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_space.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_radius1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "50%",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_radius.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
		                array(
		                    "param_name"  => "show_date1",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show date',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
		                ),
		                array(
		                    "param_name"  => "show_com1",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show comment',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_show.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_review1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show review stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
                        ),
                        array(
                            "param_name"  => "review_space1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'review_size1',
                            'type'        => 'range-responsive',
                            'value'       => '2.5',
                            'heading'     => 'Review stars size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name"  => "review_distance1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Distance between rating stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
		                array(
		                    "param_name"  => "show_excerpt1",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show excerpt',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
		                ),
                        array(
                            "param_name"  => "art_excerpt1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article excerpt space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "16px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_excerpt_space.png",
                        ),
		                array(
		                    "param_name"  => "excerpt_middle",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Excerpt in middle",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_excerpt_in_middle.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article audio player',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_audio1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Visible' => 'block',
                                'Hidden' => 'none',
                            ),
                            "heading"     => 'Show audio player',
                            "description" => "This will hide the audio player responsive",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name"  => "hide_audio",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Remove audio player",
                            "description" => "This will remove the audio player from code",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_audio1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Audio player space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_space.png",
                        ),
                        array(
                            'param_name'  => 'art_audio_size1',
                            'type'        => 'range-responsive',
                            'value'       => '1.5',
                            'heading'     => 'Audio player size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_size.png",
                        ),


		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module 2',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "modules_space2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '26',
		                    "heading"     => 'Modules bottom space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "26",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "modules_border_size2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style2",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color2",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
		                array(
		                    "param_name"  => "modules_divider2",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'None'   => '',
		                        'Solid'  => 'solid',
		                        'Dotted' => 'dotted',
		                        'Dashed' => 'dashed',
		                    ),
		                    "heading"     => 'Modules divider',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_divider.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Modules divider color',
		                    "param_name"  => "modules_divider_color2",
		                    "value"       => '#eaeaea',
		                    "description" => '',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_divider_color.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article image',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "image_size2",
		                    "type"        => "dropdown",
		                    "value"       => array(
                                'Default - 218x150px' => '',
                                '-- [No crop] --' => '__',
		                        'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Medium - 696x0px'  => 'td_696x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
		                        '324x400px'  => 'td_324x400',
		                        '485x360' => 'td_485x360'
		                    ),
		                    "heading"     => 'Image size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
		                ),
		                array(
		                    'param_name'  => 'image_alignment2',
		                    'type'        => 'range-responsive',
		                    'value'       => '50',
		                    'heading'     => 'Image V alignment',
		                    'description' => '0 - Top / 50 - Center / 100 - Bottom',
		                    'class'       => 'tdc-textfield-small',
		                    'range_min'   => '0',
		                    'range_max'   => '100',
		                    'range_step'  => '1',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_v_alignment.png",
		                ),
		                array(
		                    "param_name"  => "image_width2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image width (0-100 percent)',
		                    "description" => "Default value in percent",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "30",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
		                ),
		                array(
		                    "param_name"  => "image_height2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image height (percent)',
		                    "description" => "Default value in percent",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "50",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
		                ),
		                array(
		                    "param_name"  => "image_radius2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
		                ),
		                array(
		                    "param_name"  => "hide_image2",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Hide image",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article video',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "video_icon2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video icon size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "20",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name"  => "video_popup2",
                            "type"        => "checkbox",
                            "value"       => 'yes',
                            "heading"     => "Enable video pop-up",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_enable_video_pop-up.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name" => "video_rec2",
                            "type" => "textarea_raw_html",
                            "holder" => "div",
                            "class" => "tdc-textarea-raw-small",
                            "heading" => 'Video pop-up ad',
                            "value" => "",
                            "description" => 'Paste your ad code here.',
                            'group'      => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_popup_ad.png",
                        ),
                        array(
                            "param_name" => "spot_header",
                            "type" => "spot_header",
                            "value" => "",
                            "class" => '',
                            'group' => 'Layout',
                        ),
                        array(
                            "param_name" => "video_rec_title2",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Ad title',
                            "description" => "",
                            "placeholder" => "- Advertisement -",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-spot-controller tdc-spot-title",
                            'group'      => 'Layout',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-spot-controller tdc-spot-color",
                            "heading"     => 'Ad title color',
                            "param_name"  => "video_rec_color2",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "video_rec_disable",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Hide ADS for admins/editors",
                            "description" => "Used to prevent fake clicks and views on ads by admins and editors",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "show_vid_t2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show video duration',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_show_video_duration.png",
                        ),
                        array(
                            "param_name"  => "vid_t_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_space.png",
                        ),
                        array(
                            "param_name"  => "vid_t_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 4px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_padding.png",
                        ),
                    ),
                    self::get_map_exclusive_label_array('2', true),
                    array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article meta info',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
                        array(
                            "param_name"  => "meta_info_align2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Top'     => 'initial',
                                'Center'  => 'center',
                                'Bottom'  => 'flex-end',
                            ),
                            "heading"     => 'Meta info alignment',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_vertical_align.png",
                        ),
		                array(
		                    "param_name" => "meta_info_horiz2",
		                    "type" => "dropdown",
		                    "value" => array(
		                        'Left' => 'content-horiz-left',
		                        'Center' => 'content-horiz-center',
		                        'Right' => 'content-horiz-right'
		                    ),
		                    "heading" => 'Meta info horiz align',
		                    "description" => "",
		                    "holder" => "div",
		                    'tdc_dropdown_images' => true,
		                    "class" => "tdc-visual-selector tdc-add-class",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
		                ),
		                array(
		                    "param_name"  => "meta_width2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "100%",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
		                ),
		                array(
		                    "param_name"  => "meta_margin2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info margin',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
		                ),
		                array(
		                    "param_name"  => "meta_padding2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "13px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
		                ),
                        array(
                            "param_name"  => "meta_info_border_radius2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "art_title2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Article title space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 6px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "modules_category2",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Inline'      => '',
		                        'Above title' => 'above',
		                        'Over image'  => 'image',
		                    ),
		                    "heading"     => 'Category tag position',
		                    "description" => "Float image",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
		                ),
		                array(
		                    "param_name"  => "modules_category_margin2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category tag spacing',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_spacing.png",
		                ),
		                array(
		                    "param_name"  => "modules_category_padding2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category tag padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "3px 6px 4px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
		                ),
		                array(
		                    "param_name"  => "modules_cat_border2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_border.png",
		                ),
		                array(
		                    'param_name'  => 'modules_category_radius2',
		                    'type'        => 'range-responsive',
		                    'value'       => '0',
		                    'heading'     => 'Category tag border radius',
		                    'description' => '',
		                    'class'       => 'tdc-textfield-small',
		                    'range_min'   => '0',
		                    'range_max'   => '100',
		                    'range_step'  => '1',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_radius.png",
		                ),
		                array(
		                    "param_name"  => "show_cat2",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show category tag',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "show_author2",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show author',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
		                ),
		                array(
		                    "param_name"  => "author_photo2",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Show author photo",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "author_photo_size2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "20",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_size.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_space2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "6",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_space.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_radius2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "50%",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_radius.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
		                array(
		                    "param_name"  => "show_date2",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show date',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
		                ),
                        array(
                            "param_name"  => "show_com2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show comment',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
		                array(
		                    "param_name"  => "show_review2",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show review stars',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
		                ),
                        array(
                            "param_name"  => "review_space2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'review_size2',
                            'type'        => 'range-responsive',
                            'value'       => '2.5',
                            'heading'     => 'Review stars size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name"  => "review_distance2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Distance between rating stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article audio player',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_audio2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Visible' => 'block',
                                'Hidden' => 'none',
                            ),
                            "heading"     => 'Show audio player',
                            "description" => "This will hide the audio player responsive",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name"  => "hide_audio2",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Remove audio player",
                            "description" => "This will remove the audio player from code",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_audio2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Audio player space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_space.png",
                        ),
                        array(
                            'param_name'  => 'art_audio_size2',
                            'type'        => 'range-responsive',
                            'value'       => '1',
                            'heading'     => 'Audio player size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_size.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Pagination',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name" => "pag_space",
		                    "type" => "textfield",
		                    "value" => '',
		                    "heading" => 'Top space',
		                    "description" => "",
		                    "placeholder" => "20",
		                    "holder" => "div",
		                    "class" => "tdc-textfield-small",
		                    'group'      => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_space.png",
		                ),
		                array(
		                    "param_name"  => "pag_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_padding.png",
		                ),
		                array(
		                    "param_name"  => "pag_border_width",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "1",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_border.png",
		                ),
		                array(
		                    "param_name"  => "pag_border_radius",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Border radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_border_radius.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group" => 'Layout',
		                ),
		                array(
		                    'param_name' => 'prev_tdicon',
		                    'type' => 'icon',
		                    'heading' => 'Prev icon',
		                    'class' => 'tdc-textfield-small',
		                    'value' => '',
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow.png",
		                ),
		                array(
		                    'param_name' => 'next_tdicon',
		                    'type' => 'icon',
		                    'heading' => 'Next icon',
		                    'class' => 'tdc-textfield-small',
		                    'value' => '',
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow.png",
		                ),
		                array(
		                    "param_name"  => "pag_icons_size",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Icons size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow_size.png",
		                ),


		                array(
		                    "param_name" => "separator",
		                    "type" => "text_separator",
		                    'heading' => 'Block fonts',
		                    "value" => "",
		                    "class" => "",
		                    "group" => 'Style',
		                ),
		            ),
		            td_config_helper::get_map_block_font_array( 'f_header', true, 'Block header', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_block_header.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_ajax', false, 'Ajax categories', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_ajax.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_more', false, 'Load more button', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_load_more.png', '' ),
		            array(
		                array(
		                    "param_name" => "separator",
		                    "type" => "text_separator",
		                    'heading' => 'Module fonts',
		                    "value" => "",
		                    "class" => "",
		                    "group" => 'Style',
		                ),
		            ),
		            td_config_helper::get_map_block_font_array( 'f_title1', true, 'Article title 1', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_cat1', false, 'Article category tag 1', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_meta1', false, 'Article meta info 1', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_ex1', false, 'Article excerpt 1', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_excerpt.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_title2', false, 'Article title 2', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_cat2', false, 'Article category tag 2', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_meta2', false, 'Article meta info 2', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', '' ),
                    td_config_helper::mix_blend(),
                    td_config_helper::image_filters(),

		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Colors',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Style",
		                ),
		            ),
		            td_config_helper::get_map_block_shadow_array('shadow', 'Module Shadow', 0, 0, 0, "Style", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_shadow.png', '' ),
		            array(
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Meta info background',
		                    "param_name"  => "meta_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article title',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Article title text color',
		                    "param_name"  => "title_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_article_title.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Article title text hover',
		                    "param_name"  => "title_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name"  => "all_underline_height1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Underline size Module 1',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/style_underline.png",
		                ),
		                array(
		                    "param_name"  => "all_underline_height2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Underline size Module 2',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/style_underline.png",
		                ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Hover underline color',
                            "param_name"  => "all_underline_color",
                            "value"       => '#000',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_underline_color.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Category tag',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category background',
		                    "param_name"  => "cat_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category background hover',
		                    "param_name"  => "cat_bg_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category text color',
		                    "param_name"  => "cat_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category text hover',
		                    "param_name"  => "cat_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category border color',
		                    "param_name"  => "cat_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_border.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category border hover',
		                    "param_name"  => "cat_border_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Meta info',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Author text color',
		                    "param_name"  => "author_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Author text hover',
		                    "param_name"  => "author_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Date text color',
		                    "param_name"  => "date_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Excerpt text color',
		                    "param_name"  => "ex_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_excerpt.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Comment background',
		                    "param_name"  => "com_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Comment text color',
		                    "param_name"  => "com_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_text.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Audio player',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Buttons color',
                            "param_name"  => "audio_btn_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_buttons.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Time text color',
                            "param_name"  => "audio_time_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_time.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Bars background color',
                            "param_name"  => "audio_bar_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_bar.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Bars progress color',
                            "param_name"  => "audio_bar_curr_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_progress.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Pagination',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Text color',
		                    "param_name"  => "pag_text",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_color_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Text hover color',
		                    "param_name"  => "pag_h_text",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Background color',
		                    "param_name"  => "pag_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_color_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Background hover color',
		                    "param_name"  => "pag_h_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Border color',
		                    "param_name"  => "pag_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_color_border.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Border hover color',
		                    "param_name"  => "pag_h_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),


		                array(
		                    "param_name"  => "btn_title",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Button text',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big tdc-hidden",
		                    "placeholder" => "",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_text.png",
		                ),
		            ),
		            self::get_map_block_pagination_array()
		        )
		    )
		);

		td_api_block::add( 'td_flex_block_4',
		    array(
		        'map_in_visual_composer' => false,
		        'map_in_td_composer'     => true,
		        "name"                   => 'Flex Block 4',
		        "base"                   => 'td_flex_block_4',
		        "class"                  => 'td_flex_block_4',
		        "controls"               => "full",
		        "category"               => 'Blocks',
		        'tdc_category'           => 'Blocks',
		        'icon'                   => 'icon-pagebuilder-td_flex_block_4',
		        'file'                   => TDC_PATH_LEGACY . '/includes/shortcodes/td_flex_block_4.php',
		        'tdc_style_params' => array(
		            'custom_title',
		            'custom_url',
		            'post_ids',
		            'category_id',
		            'category_ids',
		            'tag_slug',
		            'autors_id',
		            'installed_post_types',
		            'sort',
		            'td_ajax_filter_ids',
		            'td_filter_default_txt',
		            'td_ajax_preloading',
		            'ajax_pagination_infinite_stop',
		            'offset',
		            'columns',
		            'columns_gap',
		            'limit',
		            'el_class'
		        ),
		        'tdc_start_values'       => base64_encode(
		            json_encode(
		                array(
		                    array(
		                        "modules_category" => "image",
		                        "modules_on_row" => "eyJhbGwiOiI1MCUiLCJsYW5kc2NhcGUiOiIxMDAlIn0=",
		                        "modules_category1" => "image",
		                        "show_cat2" => "none",
		                        "show_com2" => "none",
		                        "show_author2" => "none",
		                        "columns" => "50%",
		                        "columns_gap" => "eyJsYW5kc2NhcGUiOiI0MCIsInBvcnRyYWl0IjoiMjgifQ==",
		                        "image_width2" => "eyJwb3J0cmFpdCI6IjM1In0=",
		                        "modules_space1" => "eyJwaG9uZSI6IjIxIiwiYWxsIjoiMjEifQ==",
		                        "limit" => "6",
		                        "show_excerpt1" => "",
		                        "show_excerpt2" => "none",
                                "hide_audio" => "yes"
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Font family',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Montserrat/Garamond
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "394",
		                        "f_ex1_font_family" =>           "fs_4",
		                        "f_btn1_font_family" =>          "fs_4",
		                        "f_title2_font_family" =>        "394",
		                        "f_ex2_font_family" =>           "fs_4",
		                        "f_btn2_font_family" =>          "fs_4",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Source Serif/Work Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
		                        'tdc_preset_individual' =>      '1',
		                        "f_title1_font_family" =>        "721",
		                        "f_ex1_font_family" =>           "653",
		                        "f_btn1_font_family" =>          "653",
		                        "f_title2_font_family" =>        "721",
		                        "f_ex2_font_family" =>           "653",
		                        "f_btn2_font_family" =>          "653",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Raleway/Raleway
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "507",
		                        "f_ex1_font_family" =>           "507",
		                        "f_btn1_font_family" =>          "507",
		                        "f_title2_font_family" =>        "507",
		                        "f_ex2_font_family" =>           "507",
		                        "f_btn2_font_family" =>          "507",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Work Sans/Work Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "653",
		                        "f_ex1_font_family" =>           "653",
		                        "f_btn1_font_family" =>          "653",
		                        "f_title2_font_family" =>        "653",
		                        "f_ex2_font_family" =>           "653",
		                        "f_btn2_font_family" =>          "653",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Courgette/Open Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "147",
		                        "f_ex1_font_family" =>           "",
		                        "f_btn1_font_family" =>          "",
		                        "f_title2_font_family" =>        "147",
		                        "f_ex2_font_family" =>           "",
		                        "f_btn2_font_family" =>          "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Oswald/EB garamond
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "445",
		                        "f_ex1_font_family" =>           "185",
		                        "f_btn1_font_family" =>          "185",
		                        "f_title2_font_family" =>        "445",
		                        "f_ex2_font_family" =>           "185",
		                        "f_btn2_font_family" =>          "185",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Muli/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "406",
		                        "f_ex1_font_family" =>           "406",
		                        "f_btn1_font_family" =>          "406",
		                        "f_title2_font_family" =>        "406",
		                        "f_ex2_font_family" =>           "406",
		                        "f_btn2_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Wendy One/Josefin Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "646",
		                        "f_ex1_font_family" =>           "297",
		                        "f_btn1_font_family" =>          "297",
		                        "f_title2_font_family" =>        "646",
		                        "f_ex2_font_family" =>           "297",
		                        "f_btn2_font_family" =>          "297",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Anton/Roboto Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "41",
		                        "f_ex1_font_family" =>           "523",
		                        "f_btn1_font_family" =>          "523",
		                        "f_title2_font_family" =>        "41",
		                        "f_ex2_font_family" =>           "523",
		                        "f_btn2_font_family" =>          "523",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Quicksand/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "502",
		                        "f_ex1_font_family" =>           "406",
		                        "f_btn1_font_family" =>          "406",
		                        "f_title2_font_family" =>        "502",
		                        "f_ex2_font_family" =>           "406",
		                        "f_btn2_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Libre Baskerville/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "331",
		                        "f_ex1_font_family" =>           "406",
		                        "f_btn1_font_family" =>          "406",
		                        "f_title2_font_family" =>        "331",
		                        "f_ex2_font_family" =>           "406",
		                        "f_btn2_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Caveat/Josefin Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "663",
		                        "f_ex1_font_family" =>           "297",
		                        "f_btn1_font_family" =>          "297",
		                        "f_title2_font_family" =>        "663",
		                        "f_ex2_font_family" =>           "297",
		                        "f_btn2_font_family" =>          "297",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Volkorn/Montserrat
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "639",
		                        "f_ex1_font_family" =>           "394",
		                        "f_btn1_font_family" =>          "394",
		                        "f_title2_font_family" =>        "639",
		                        "f_ex2_font_family" =>           "394",
		                        "f_btn2_font_family" =>          "394",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Default
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_family" =>        "",
		                        "f_ex1_font_family" =>           "",
		                        "f_btn1_font_family" =>          "",
		                        "f_title2_font_family" =>        "",
		                        "f_ex2_font_family" =>           "",
		                        "f_btn2_font_family" =>          "",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Font size',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XS 13/13/12/14
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
		                        "f_title1_font_line_height" => "1.3",
		                        "f_ex1_font_size" => "",
		                        "f_ex1_font_line_height" => "",
		                        "f_title2_font_size" => "eyJhbGwiOiIxMiIsInBvcnRyYWl0IjoiMTEiLCJwaG9uZSI6IjEzIn0=",
		                        "f_title2_font_line_height" => "1.3",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - S 14/13/12/14
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
		                        "f_title1_font_line_height" => "1.4",
		                        "f_ex1_font_size" => "",
		                        "f_ex1_font_line_height" => "",
		                        "f_title2_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIifQ==",
		                        "f_title2_font_line_height" => "eyJwaG9uZSI6IjEuMyIsImFsbCI6IjEuNCJ9",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - M 21/21/17/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_size" => "eyJhbGwiOiIyMSIsImxhbmRzY2FwZSI6IjIwIiwicG9ydHJhaXQiOiIxNyJ9",
		                        "f_title1_font_line_height" => "1.2",
		                        "f_ex1_font_size" => "",
		                        "f_ex1_font_line_height" => "",
		                        "f_title2_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_title2_font_line_height" => "1.4",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - L 26/25/21/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_size" => "eyJhbGwiOiIyNiIsImxhbmRzY2FwZSI6IjI1IiwicG9ydHJhaXQiOiIyMSIsInBob25lIjoiMjEifQ==",
		                        "f_title1_font_line_height" => "1.2",
		                        "f_ex1_font_size" => "eyJhbGwiOiIxNCIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_ex1_font_line_height" => "1.5",
		                        "f_title2_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_title2_font_line_height" => "1.4",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XL 30/28/24/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
		                        "f_title1_font_line_height" => "1.2",
		                        "f_title2_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_title2_font_line_height" => "1.4",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XXL 36/32/26/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
		                        'tdc_preset_individual' => '1',
		                        "f_title1_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
		                        "f_title1_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
		                        "f_ex1_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTQiLCJwaG9uZSI6IjEzIn0=",
		                        "f_ex1_font_line_height" => "1.5",
		                        "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQiLCJwaG9uZSI6IjE0IiwibGFuZHNjYXBlIjoiMTUifQ==",
		                        "f_title2_font_line_height" => "1.4",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Text alignment',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - left
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz1" => "content-horiz-left",
		                        "meta_info_horiz2" => "content-horiz-left",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - center
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz1" => "content-horiz-center",
		                        "meta_info_horiz2" => "content-horiz-center",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - right
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz1" => "content-horiz-right",
		                        "meta_info_horiz2" => "content-horiz-right",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Image format',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_image',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - OFF
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image1',
		                        'tdc_preset_individual' => '1',
		                        "hide_image" => "yes",
		                        "hide_image3" => "yes",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 2:3
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image2',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "150",
		                        "image_height2" => "150",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 3:4
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image3',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "133",
		                        "image_height2" => "133",
		                        "hide_image" => "",
		                        "hide_image1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 7:8
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image4',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "114",
		                        "image_height2" => "114",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 1:1
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image5',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "100",
		                        "image_height2" => "100",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 5:4
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image6',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "80",
		                        "image_height2" => "80",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 4:3
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image7',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "75",
		                        "image_height2" => "75",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 3:2
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image8',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "67",
		                        "image_height2" => "67",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 16:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image9',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "56",
		                        "image_height2" => "56",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 18:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image10',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "50",
		                        "image_height2" => "50",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 21:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image11',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "40",
		                        "image_height2" => "40",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 30:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image12',
		                        'tdc_preset_individual' => '1',
		                        "image_height1" => "30",
		                        "image_height2" => "30",
		                        "hide_image" => "",
		                        "hide_image2" => "",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Color library',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_color',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Color library
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color1',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#f9c100',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color2',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#ff7500',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color3',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#f44336',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color4',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#ff036e',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color5',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#58c7db',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color6',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#607d8b',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color7',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#005689',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color8',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#997df3',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color9',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#4caf50',
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Columns',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_col',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 1
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col1',
		                        'tdc_preset_individual' => '1',
		                        "columns" => "100%",
		                        "modules_gap" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 2
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col2',
		                        'tdc_preset_individual' => '1',
		                        "columns" => "50%",
		                        "columns_gap" => "eyJhbGwiOiI0OCIsInBvcnRyYWl0IjoiMjgiLCJsYW5kc2NhcGUiOiI0MCJ9",
		                        "limit" => "6",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 3
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col3',
		                        'tdc_preset_individual' => '1',
		                        "columns" => "33.33333333%",
		                        "columns_gap" => "eyJhbGwiOiI0OCIsInBvcnRyYWl0IjoiMjgiLCJsYW5kc2NhcGUiOiI0MCJ9",
		                        "limit" => "9",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 4
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col4',
		                        'tdc_preset_individual' => '1',
		                        "columns" => "25%",
		                        "columns_gap" => "eyJhbGwiOiIxLjIlIiwicGhvbmUiOiIzJSJ9",
		                        "limit" => "12",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 5
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col5',
		                        'tdc_preset_individual' => '1',
		                        "columns" => "20%",
		                        "columns_gap" => "1%",
		                        "limit" => "15",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Show/Hide module elements',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_elements',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_cat1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_cat1" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s tdcp_elements_s_small',
		                        'tdc_preset_individual' => '1',
		                        "show_cat2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_cat2" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Category tag', // Category tag
		                        'tdc_preset_class' => 'tdcp_elements_text tdcp_elements_text_small',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_author1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_author1" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s tdcp_elements_s_small',
		                        'tdc_preset_individual' => '1',
		                        "show_author2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_author2" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Author', // Author
		                        'tdc_preset_class' => 'tdcp_elements_text tdcp_elements_text_small',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_date1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_date1" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s tdcp_elements_s_small',
		                        'tdc_preset_individual' => '1',
		                        "show_date2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_date2" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Date', // Author
		                        'tdc_preset_class' => 'tdcp_elements_text tdcp_elements_text_small',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_review1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_review1" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s tdcp_elements_s_small',
		                        'tdc_preset_individual' => '1',
		                        "show_review2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_review2" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Review stars', // Review
		                        'tdc_preset_class' => 'tdcp_elements_text tdcp_elements_text_small',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_com1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_com1" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s tdcp_elements_s_small',
		                        'tdc_preset_individual' => '1',
		                        "show_com2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_com2" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Comment tag', // Comment tag
		                        'tdc_preset_class' => 'tdcp_elements_text tdcp_elements_text_small',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt1" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h tdcp_clear',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt1" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s tdcp_elements_s_small',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt2" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h tdcp_clear',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt2" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Excerpt', // Excerpt
		                        'tdc_preset_class' => 'tdcp_elements_text tdcp_elements_text_small',
		                    ),
		                )
		            )
		        ),
		        "params"                 => array_merge(
		            self::get_map_block_general_array(),

		            array(
                        array(
                            "param_name" => "title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H4' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H3' => 'h3',
                                'Div' => 'div'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/title_seo.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Content length',
		                    "value"      => "",
		                    "class"      => "",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module Flex 1',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                ),
		                array(
		                    "param_name"  => "mc1_tl",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Title length',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
		                ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
		                array(
		                    "param_name"  => "mc1_el",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Excerpt length',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "25",
                            "info_img" => "https://cloud.tagdiv.com/help/excerpt_length.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module Flex 4',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                ),
		                array(
		                    "param_name"  => "mc4_tl",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Title length',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
		                ),
                        array(
                            "param_name" => "mc4_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
		                array(
		                    "param_name"  => "mc4_el",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Excerpt length',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "25",
                            "info_img" => "https://cloud.tagdiv.com/help/excerpt_length.png",
		                ),
		            ),

		            self::get_map_filter_array(),
		            self::get_map_block_ajax_filter_array(),

		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Layout',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "columns",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        '1'  => '100%',
		                        '2'  => '50%',
		                        '3'  => '33.33333333%',
		                        '4'  => '25%',
		                        '5'  => '20%',
		                    ),
		                    "heading"     => 'Columns',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-small",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "columns_gap",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Columns gap',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "48",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "h_effect",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'None'   => '',
		                        'Shadow'  => 'shadow',
		                        'Move up & shadow'  => 'up-shadow',
		                    ),
		                    "heading"     => 'Hover effect',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hover_effect.png",
		                ),


		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module 1',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "modules_space1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '21',
		                    "heading"     => 'Modules bottom space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "21",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "modules_border_size1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style1",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color1",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
		                array(
		                    "param_name"  => "modules_divider1",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'None'   => '',
		                        'Solid'  => 'solid',
		                        'Dotted' => 'dotted',
		                        'Dashed' => 'dashed',
		                    ),
		                    "heading"     => 'Module divider',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_divider.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Module divider color',
		                    "param_name"  => "modules_divider_color1",
		                    "value"       => '#eaeaea',
		                    "description" => '',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_divider_color.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article image',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "image_size",
		                    "type"        => "dropdown",
		                    "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
		                    ),
		                    "heading"     => 'Image size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
		                ),
		                array(
		                    'param_name'  => 'image_alignment1',
		                    'type'        => 'range-responsive',
		                    'value'       => '50',
		                    'heading'     => 'Image V alignment',
		                    'description' => '0 - Top / 50 - Center / 100 - Bottom',
		                    'class'       => 'tdc-textfield-small',
		                    'range_min'   => '0',
		                    'range_max'   => '100',
		                    'range_step'  => '1',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_v_alignment.png",
		                ),
		                array(
		                    "param_name"  => "image_height1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image height (percent)',
		                    "description" => "Default value in percent",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "50",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
		                ),
		                array(
		                    "param_name"  => "image_radius1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
		                ),
		                array(
		                    "param_name"  => "hide_image",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Hide image",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article video',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "video_icon1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video icon size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name"  => "video_icon_pos1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Center'  => 'center',
                                'Corner' => 'corner',
                            ),
                            "heading"     => 'Video icon position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "video_popup",
                            "type"        => "checkbox",
                            "value"       => 'yes',
                            "heading"     => "Enable video pop-up",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_enable_video_pop-up.png",
                        ),
                        array(
                            "param_name" => "video_rec",
                            "type" => "textarea_raw_html",
                            "holder" => "div",
                            "class" => "tdc-textarea-raw-small",
                            "heading" => 'Video pop-up ad',
                            "value" => "",
                            "description" => 'Paste your ad code here.',
                            'group'      => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_popup_ad.png",
                        ),
                        array(
                            "param_name" => "spot_header",
                            "type" => "spot_header",
                            "value" => "",
                            "class" => '',
                            'group' => 'Layout',
                        ),
                        array(
                            "param_name" => "video_rec_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Ad title',
                            "description" => "",
                            "placeholder" => "- Advertisement -",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-spot-controller tdc-spot-title",
                            'group'      => 'Layout',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-spot-controller tdc-spot-color",
                            "heading"     => 'Ad title color',
                            "param_name"  => "video_rec_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "video_rec_disable",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Hide ADS for admins/editors",
                            "description" => "Used to prevent fake clicks and views on ads by admins and editors",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "show_vid_t",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show video duration',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_show_video_duration.png",
                        ),
                        array(
                            "param_name"  => "vid_t_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_space.png",
                        ),
                        array(
                            "param_name"  => "vid_t_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 4px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Video pop-up article title color',
                            "param_name"  => "video_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_title_color.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Video pop-up article title hover color',
                            "param_name"  => "video_title_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "video_bg",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Video pop-up background color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_background.png",
                        ),
                        array(
                            "param_name" => "video_overlay",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Video pop-up overlay color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_overlay_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name" => "vid_t_color",
                            "holder"     => "div",
                            "type"       => "colorpicker",
                            'heading'    => "Video duration text color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_text_color.png",
                        ),
                        array(
                            "param_name" => "vid_t_bg_color",
                            "holder"     => "div",
                            "type"       => "colorpicker",
                            'heading'    => "Video duration background color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_bg_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Layout',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_vid_title', true, 'Video pop-up article title', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_article_title.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_vid_time', false, 'Video duration text', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_duration_title.png', '' ),
                    self::get_map_exclusive_label_array('1', true),
                    array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article meta info',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "meta_info_align1",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Bottom'        => '',
		                        'Top'           => 'initial',
		                        'Over image'    => 'image',
		                    ),
		                    "heading"     => 'Meta info alignment',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_vertical_align.png",
		                ),
		                array(
		                    "param_name" => "meta_info_horiz1",
		                    "type" => "dropdown",
		                    "value" => array(
		                        'Left' => 'content-horiz-left',
		                        'Center' => 'content-horiz-center',
		                        'Right' => 'content-horiz-right'
		                    ),
		                    "heading" => 'Meta info horiz align',
		                    "description" => "",
		                    "holder" => "div",
		                    'tdc_dropdown_images' => true,
		                    "class" => "tdc-visual-selector tdc-add-class",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
		                ),
		                array(
		                    "param_name"  => "meta_width1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "100%",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
		                ),
		                array(
		                    "param_name"  => "meta_margin1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info margin',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
		                ),
		                array(
		                    "param_name"  => "meta_padding1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "13px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
		                ),
                        array(
                            "param_name"  => "meta_info_border_radius1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "art_title1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Article title space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 6px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "modules_category",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Inline'      => '',
		                        'Above title' => 'above',
		                        'Over image'  => 'image',
		                    ),
		                    "heading"     => 'Category tag position',
		                    "description" => "Float image",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
		                ),
		                array(
		                    "param_name"  => "modules_category_margin1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category tag spacing',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_spacing.png",
		                ),
		                array(
		                    "param_name"  => "modules_category_padding1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category tag padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "3px 6px 4px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
		                ),
		                array(
		                    "param_name"  => "modules_cat_border1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_border.png",
		                ),
		                array(
		                    'param_name'  => 'modules_category_radius1',
		                    'type'        => 'range-responsive',
		                    'value'       => '0',
		                    'heading'     => 'Category tag border radius',
		                    'description' => '',
		                    'class'       => 'tdc-textfield-small',
		                    'range_min'   => '0',
		                    'range_max'   => '100',
		                    'range_step'  => '1',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_radius.png",
		                ),
		                array(
		                    "param_name"  => "show_cat1",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show category tag',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "show_author1",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show author',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
		                ),
		                array(
		                    "param_name"  => "author_photo",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Show author photo",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_size1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "20",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_size.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_space1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "6",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_space.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_radius1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "50%",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_radius.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
		                array(
		                    "param_name"  => "show_date1",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show date',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
		                ),
		                array(
		                    "param_name"  => "show_com1",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show comment',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_show.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_review1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show review stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
                        ),
                        array(
                            "param_name"  => "review_space1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'review_size1',
                            'type'        => 'range-responsive',
                            'value'       => '2.5',
                            'heading'     => 'Review stars size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name"  => "review_distance1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Distance between rating stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
		                array(
		                    "param_name"  => "show_excerpt1",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show excerpt',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
		                ),
                        array(
                            "param_name"  => "art_excerpt1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article excerpt space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "16px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_excerpt_space.png",
                        ),
		                array(
		                    "param_name"  => "excerpt_middle",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Excerpt in middle",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_excerpt_in_middle.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article audio player',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_audio1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Visible' => 'block',
                                'Hidden' => 'none',
                            ),
                            "heading"     => 'Show audio player',
                            "description" => "This will hide the audio player responsive",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name"  => "hide_audio",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Remove audio player",
                            "description" => "This will remove the audio player from code",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_audio1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Audio player space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_space.png",
                        ),
                        array(
                            'param_name'  => 'art_audio_size1',
                            'type'        => 'range-responsive',
                            'value'       => '1.5',
                            'heading'     => 'Audio player size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_size.png",
                        ),


		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module 2',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "m_padding2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Modules padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
		                ),
		                array(
		                    "param_name"  => "modules_space2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '26',
		                    "heading"     => 'Modules bottom space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "26",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "modules_border_size2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style2",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color2",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
		                array(
		                    "param_name"  => "modules_divider2",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'None'   => '',
		                        'Solid'  => 'solid',
		                        'Dotted' => 'dotted',
		                        'Dashed' => 'dashed',
		                    ),
		                    "heading"     => 'Modules divider',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_divider.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Modules divider color',
		                    "param_name"  => "modules_divider_color2",
		                    "value"       => '#eaeaea',
		                    "description" => '',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_divider_color.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article image',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "image_size3",
		                    "type"        => "dropdown",
		                    "value"       => array(
                                'Default - 218x150px' => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Medium - 696x0px'  => 'td_696x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
		                    ),
		                    "heading"     => 'Image size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
		                ),
		                array(
		                    'param_name'  => 'image_alignment2',
		                    'type'        => 'range-responsive',
		                    'value'       => '50',
		                    'heading'     => 'Image V alignment',
		                    'description' => '0 - Top / 50 - Center / 100 - Bottom',
		                    'class'       => 'tdc-textfield-small',
		                    'range_min'   => '0',
		                    'range_max'   => '100',
		                    'range_step'  => '1',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_v_alignment.png",
		                ),
		                array(
		                    "param_name"  => "image_width2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image width (0-100 percent)',
		                    "description" => "Default value in percent",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "30",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
		                ),
		                array(
		                    "param_name"  => "image_height2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image height (percent)',
		                    "description" => "Default value in percent",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "70",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
		                ),
		                array(
		                    "param_name"  => "image_radius2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
		                ),
		                array(
		                    "param_name"  => "hide_image3",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Hide image",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article video',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "video_icon2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video icon size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "20",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name"  => "video_popup3",
                            "type"        => "checkbox",
                            "value"       => 'yes',
                            "heading"     => "Enable video pop-up",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_enable_video_pop-up.png",
                        ),
                        array(
                            "param_name" => "video_rec3",
                            "type" => "textarea_raw_html",
                            "holder" => "div",
                            "class" => "tdc-textarea-raw-small",
                            "heading" => 'Video pop-up ad',
                            "value" => "",
                            "description" => 'Paste your ad code here.',
                            'group'      => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_popup_ad.png",
                        ),
                        array(
                            "param_name" => "spot_header",
                            "type" => "spot_header",
                            "value" => "",
                            "class" => '',
                            'group' => 'Layout',
                        ),
                        array(
                            "param_name" => "video_rec_title3",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Ad title',
                            "description" => "",
                            "placeholder" => "- Advertisement -",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-spot-controller tdc-spot-title",
                            'group'      => 'Layout',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-spot-controller tdc-spot-color",
                            "heading"     => 'Ad title color',
                            "param_name"  => "video_rec_color3",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "video_rec_disable",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Hide ADS for admins/editors",
                            "description" => "Used to prevent fake clicks and views on ads by admins and editors",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "show_vid_t3",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show video duration',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_show_video_duration.png",
                        ),
                        array(
                            "param_name"  => "vid_t_margin3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_space.png",
                        ),
                        array(
                            "param_name"  => "vid_t_padding3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 4px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_padding.png",
                        ),
                    ),
                    self::get_map_exclusive_label_array('2', true),
                    array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article meta info',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name" => "meta_info_horiz2",
		                    "type" => "dropdown",
		                    "value" => array(
		                        'Left' => 'content-horiz-left',
		                        'Center' => 'content-horiz-center',
		                        'Right' => 'content-horiz-right'
		                    ),
		                    "heading" => 'Meta info horiz align',
		                    "description" => "",
		                    "holder" => "div",
		                    'tdc_dropdown_images' => true,
		                    "class" => "tdc-visual-selector tdc-add-class",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
		                ),
		                array(
		                    "param_name"  => "meta_width2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "100%",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
		                ),
		                array(
		                    "param_name"  => "meta_margin2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info margin',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
		                ),
		                array(
		                    "param_name"  => "meta_padding2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "13px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
		                ),
                        array(
                            "param_name"  => "meta_info_border_radius2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "art_title2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Article title space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 6px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "modules_category3",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Inline'      => '',
		                        'Above title' => 'above',
		                        'Over image'  => 'image',
		                    ),
		                    "heading"     => 'Category tag position',
		                    "description" => "Float image",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
		                ),
		                array(
		                    "param_name"  => "modules_category_margin2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category tag spacing',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_spacing.png",
		                ),
		                array(
		                    "param_name"  => "modules_category_padding2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category tag padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "3px 6px 4px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
		                ),
		                array(
		                    "param_name"  => "modules_cat_border2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_border.png",
		                ),
		                array(
		                    'param_name'  => 'modules_category_radius2',
		                    'type'        => 'range-responsive',
		                    'value'       => '0',
		                    'heading'     => 'Category tag border radius',
		                    'description' => '',
		                    'class'       => 'tdc-textfield-small',
		                    'range_min'   => '0',
		                    'range_max'   => '100',
		                    'range_step'  => '1',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_radius.png",
		                ),
		                array(
		                    "param_name"  => "show_cat2",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show category tag',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Layout",
		                ),
		                array(
		                    "param_name"  => "show_author2",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show author',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
		                ),
		                array(
		                    "param_name"  => "author_photo3",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Show author photo",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "author_photo_size2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "20",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_size.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_space2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "6",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_space.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_radius2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "50%",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_radius.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
		                array(
		                    "param_name"  => "show_date2",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show date',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
		                ),
		                array(
		                    "param_name"  => "show_com2",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show comment',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_show.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_review2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show review stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
                        ),
                        array(
                            "param_name"  => "review_space2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'review_size2',
                            'type'        => 'range-responsive',
                            'value'       => '2.5',
                            'heading'     => 'Review stars size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name"  => "review_distance2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Distance between rating stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
		                array(
		                    "param_name"  => "show_excerpt2",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show excerpt',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
		                ),
                        array(
                            "param_name"  => "art_excerpt2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article excerpt space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "16px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_excerpt_space.png",
                        ),
		                array(
		                    "param_name"  => "excerpt_middle3",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Excerpt in middle",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_excerpt_in_middle.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article audio player',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_audio2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Visible' => 'block',
                                'Hidden' => 'none',
                            ),
                            "heading"     => 'Show audio player',
                            "description" => "This will hide the audio player responsive",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name"  => "hide_audio3",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Remove audio player",
                            "description" => "This will remove the audio player from code",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_audio2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Audio player space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_space.png",
                        ),
                        array(
                            'param_name'  => 'art_audio_size2',
                            'type'        => 'range-responsive',
                            'value'       => '1',
                            'heading'     => 'Audio player size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_size.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Pagination',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name" => "pag_space",
		                    "type" => "textfield",
		                    "value" => '',
		                    "heading" => 'Top space',
		                    "description" => "",
		                    "placeholder" => "20",
		                    "holder" => "div",
		                    "class" => "tdc-textfield-small",
		                    'group'      => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_space.png",
		                ),
		                array(
		                    "param_name"  => "pag_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_padding.png",
		                ),
		                array(
		                    "param_name"  => "pag_border_width",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "1",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_border.png",
		                ),
		                array(
		                    "param_name"  => "pag_border_radius",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Border radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_border_radius.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group" => 'Layout',
		                ),
		                array(
		                    'param_name' => 'prev_tdicon',
		                    'type' => 'icon',
		                    'heading' => 'Prev icon',
		                    'class' => 'tdc-textfield-small',
		                    'value' => '',
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow.png",
		                ),
		                array(
		                    'param_name' => 'next_tdicon',
		                    'type' => 'icon',
		                    'heading' => 'Next icon',
		                    'class' => 'tdc-textfield-small',
		                    'value' => '',
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow.png",
		                ),
		                array(
		                    "param_name"  => "pag_icons_size",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Icons size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow_size.png",
		                ),


		                array(
		                    "param_name" => "separator",
		                    "type" => "text_separator",
		                    'heading' => 'Block fonts',
		                    "value" => "",
		                    "class" => "",
		                    "group" => 'Style',
		                ),
		            ),
		            td_config_helper::get_map_block_font_array( 'f_header', true, 'Block header', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_block_header.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_ajax', false, 'Ajax categories', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_ajax.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_more', false, 'Load more button', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_load_more.png', '' ),
		            array(
		                array(
		                    "param_name" => "separator",
		                    "type" => "text_separator",
		                    'heading' => 'Module fonts',
		                    "value" => "",
		                    "class" => "",
		                    "group" => 'Style',
		                ),
		            ),
		            td_config_helper::get_map_block_font_array( 'f_title1', true, 'Article title 1', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_cat1', false, 'Article category tag 1', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_meta1', false, 'Article meta info 1', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_ex1', false, 'Article excerpt 1', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_excerpt.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_title2', false, 'Article title 2', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_cat2', false, 'Article category tag 2', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_meta2', false, 'Article meta info 2', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_ex2', false, 'Article excerpt 2', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_excerpt.png', '' ),
                    td_config_helper::mix_blend(),
                    td_config_helper::image_filters(),
		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Colors',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Style",
		                ),
		            ),
		            td_config_helper::get_map_block_shadow_array('shadow', 'Module Shadow', 0, 0, 0, "Style", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_shadow.png', '' ),
		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module 1 colors',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name" => "color_overlay",
		                    "holder"     => "div",
		                    "type"       => "gradient",
		                    'heading'    => "Module image overlay",
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_overlay.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Meta info background',
		                    "param_name"  => "meta_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Style",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Article title text color',
		                    "param_name"  => "title_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_article_title.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Article title text hover',
		                    "param_name"  => "title_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name"  => "all_underline_height1",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Underline size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/style_underline.png",
		                ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Hover underline color',
                            "param_name"  => "all_underline_color1",
                            "value"       => '#000',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_underline_color.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Style",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category background',
		                    "param_name"  => "cat_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category background hover',
		                    "param_name"  => "cat_bg_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category text color',
		                    "param_name"  => "cat_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category text hover',
		                    "param_name"  => "cat_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category border color',
		                    "param_name"  => "cat_border1",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_border.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category border hover',
		                    "param_name"  => "cat_border_hover1",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Style",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Author text color',
		                    "param_name"  => "author_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Author text hover',
		                    "param_name"  => "author_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Date text color',
		                    "param_name"  => "date_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Excerpt text color',
		                    "param_name"  => "ex_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_excerpt.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Comment background',
		                    "param_name"  => "com_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Comment text color',
		                    "param_name"  => "com_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_text.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Audio player buttons color',
                            "param_name"  => "audio_btn_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_buttons.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Audio player time text color',
                            "param_name"  => "audio_time_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_time.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Audio player bars background color',
                            "param_name"  => "audio_bar_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_bar.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Audio player bars progress color',
                            "param_name"  => "audio_bar_curr_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_progress.png",
                        ),


		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module 2 colors',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Meta info background',
		                    "param_name"  => "meta_bg2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Style",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Article title text color',
		                    "param_name"  => "title_txt2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_article_title.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Article title text hover',
		                    "param_name"  => "title_txt_hover2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name"  => "all_underline_height2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Underline size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/style_underline.png",
		                ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Hover underline color',
                            "param_name"  => "all_underline_color2",
                            "value"       => '#000',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_underline_color.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Style",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category background',
		                    "param_name"  => "cat_bg2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category background hover',
		                    "param_name"  => "cat_bg_hover2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category text color',
		                    "param_name"  => "cat_txt2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category text hover',
		                    "param_name"  => "cat_txt_hover2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category border color',
		                    "param_name"  => "cat_border2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_border.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category border hover',
		                    "param_name"  => "cat_border_hover2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group"       => "Style",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Author text color',
		                    "param_name"  => "author_txt2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Author text hover',
		                    "param_name"  => "author_txt_hover2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Date text color',
		                    "param_name"  => "date_txt2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Excerpt text color',
		                    "param_name"  => "ex_txt2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_excerpt.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Comment background',
		                    "param_name"  => "com_bg2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Comment text color',
		                    "param_name"  => "com_txt2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_text.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Audio player buttons color',
                            "param_name"  => "audio_btn_color2",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_buttons.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Audio player time text color',
                            "param_name"  => "audio_time_color2",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_time.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Audio player bars background color',
                            "param_name"  => "audio_bar_color2",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_bar.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Audio player bars progress color',
                            "param_name"  => "audio_bar_curr_color2",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_progress.png",
                        ),


		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Pagination',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Text color',
		                    "param_name"  => "pag_text",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_color_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Text hover color',
		                    "param_name"  => "pag_h_text",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Background color',
		                    "param_name"  => "pag_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_color_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Background hover color',
		                    "param_name"  => "pag_h_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Border color',
		                    "param_name"  => "pag_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_color_border.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Border hover color',
		                    "param_name"  => "pag_h_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),


		                array(
		                    "param_name"  => "btn_title",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Button text',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big tdc-hidden",
		                    "placeholder" => "",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_text.png",
		                ),
		            ),
		            self::get_map_block_pagination_array()
		        )
		    )
		);

		td_api_block::add( 'td_flex_block_5',
		    array(
		        'map_in_visual_composer' => false,
		        'map_in_td_composer'     => true,
		        "name"                   => 'Flex Block 5',
		        "base"                   => 'td_flex_block_5',
		        "class"                  => 'td_flex_block_5',
		        "controls"               => "full",
		        "category"               => 'Blocks',
		        'tdc_category'           => 'Blocks',
		        'icon'                   => 'icon-pagebuilder-td_flex_block_5',
		        'file'                   => TDC_PATH_LEGACY . '/includes/shortcodes/td_flex_block_5.php',
		        'tdc_style_params' => array(
		            'custom_title',
		            'custom_url',
		            'post_ids',
		            'category_id',
		            'category_ids',
		            'tag_slug',
		            'autors_id',
		            'installed_post_types',
		            'sort',
		            'td_ajax_filter_ids',
		            'td_filter_default_txt',
		            'td_ajax_preloading',
		            'ajax_pagination_infinite_stop',
		            'offset',
		            'modules_on_row',
		            'modules_gap',
		            'limit',
		            'el_class'
		        ),
		        'tdc_start_values'       => base64_encode(
		            json_encode(
		                array(
		                    array(
		                        "art_title_pos" => "bottom",
		                        "info_pos" => "bottom",
		                        "art_excerpt_pos" => "bottom",
                                "art_audio_pos" => "bottom",
		                        "modules_category" => "image",
		                        "btn_pos" => "bottom",
                                "hide_audio" => "yes"
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Font family',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Montserrat/Garamond
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "394",
		                        "f_ex_font_family" =>           "fs_4",
		                        "f_btn_font_family" =>          "fs_4",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Source Serif/Work Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
		                        'tdc_preset_individual' =>      '1',
		                        "f_title_font_family" =>        "721",
		                        "f_ex_font_family" =>           "653",
		                        "f_btn_font_family" =>          "653",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Raleway/Raleway
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "507",
		                        "f_ex_font_family" =>           "507",
		                        "f_btn_font_family" =>          "507",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Work Sans/Work Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "653",
		                        "f_ex_font_family" =>           "653",
		                        "f_btn_font_family" =>          "653",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Courgette/Open Sans
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "147",
		                        "f_ex_font_family" =>           "",
		                        "f_btn_font_family" =>          "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Oswald/EB garamond
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "445",
		                        "f_ex_font_family" =>           "185",
		                        "f_btn_font_family" =>          "185",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Muli/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "406",
		                        "f_ex_font_family" =>           "406",
		                        "f_btn_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Wendy One/Josefin Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "646",
		                        "f_ex_font_family" =>           "297",
		                        "f_btn_font_family" =>          "297",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Anton/Roboto Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "41",
		                        "f_ex_font_family" =>           "523",
		                        "f_btn_font_family" =>          "523",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Quicksand/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "502",
		                        "f_ex_font_family" =>           "406",
		                        "f_btn_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Libre Baskerville/Muli
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "331",
		                        "f_ex_font_family" =>           "406",
		                        "f_btn_font_family" =>          "406",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Caveat/Josefin Slab
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "663",
		                        "f_ex_font_family" =>           "297",
		                        "f_btn_font_family" =>          "297",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Volkorn/Montserrat
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "639",
		                        "f_ex_font_family" =>           "394",
		                        "f_btn_font_family" =>          "394",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Font - Default
		                        'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_family" =>        "",
		                        "f_ex_font_family" =>           "",
		                        "f_btn_font_family" =>          "",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Font size',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XS 13/13/12/14
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
		                        "f_title_font_line_height" => "1.3",
		                        "f_ex_font_size" => "=",
		                        "f_ex_font_line_height" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - S 14/13/12/14
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
		                        "f_title_font_line_height" => "1.4",
		                        "f_ex_font_size" => "=",
		                        "f_ex_font_line_height" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - M 21/21/17/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIyMSIsImxhbmRzY2FwZSI6IjIwIiwicG9ydHJhaXQiOiIxNyJ9",
		                        "f_title_font_line_height" => "1.2",
		                        "f_ex_font_size" => "=",
		                        "f_ex_font_line_height" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - L 26/25/21/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIyNiIsImxhbmRzY2FwZSI6IjI1IiwicG9ydHJhaXQiOiIyMSIsInBob25lIjoiMjEifQ==",
		                        "f_title_font_line_height" => "1.2",
		                        "f_ex_font_size" => "eyJhbGwiOiIxNCIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_ex_font_line_height" => "1.5",

		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XL 30/28/24/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
		                        "f_title_font_line_height" => "1.2",
		                        "f_ex_font_size" => "eyJhbGwiOiIxNCIsInBvcnRyYWl0IjoiMTMiLCJwaG9uZSI6IjEzIn0=",
		                        "f_ex_font_line_height" => "1.5",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Size - XXL 36/32/26/21
		                        'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
		                        'tdc_preset_individual' => '1',
		                        "f_title_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
		                        "f_title_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
		                        "f_ex_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTQiLCJwaG9uZSI6IjEzIn0=",
		                        "f_ex_font_line_height" => "1.5",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Text alignment',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - left
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz" => "content-horiz-left",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - center
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz" => "content-horiz-center",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Text alignment - right
		                        'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
		                        'tdc_preset_individual' => '1',
		                        "meta_info_horiz" => "content-horiz-right",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Image format',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_image',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - OFF
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image1',
		                        'tdc_preset_individual' => '1',
		                        "hide_image" => "yes",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 2:3
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image2',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "150",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 3:4
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image3',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "133",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 7:8
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image4',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "114",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 1:1
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image5',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "100",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 5:4
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image6',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "80",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 4:3
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image7',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "75",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 3:2
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image8',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "67",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 16:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image9',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "56",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 18:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image10',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "50",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 21:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image11',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "40",
		                        "hide_image" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Image format - 30:9
		                        'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_image12',
		                        'tdc_preset_individual' => '1',
		                        "image_height" => "30",
		                        "hide_image" => "",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Color library',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_color',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Color library
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color1',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#f9c100',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color2',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#ff7500',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color3',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#f44336',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color4',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#ff036e',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color5',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#58c7db',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color6',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#607d8b',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color7',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#005689',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color8',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#997df3',
		                    ),
		                    array(
		                        'tdc_preset_name' => '',
		                        'tdc_preset_class' => 'tdcp_img tdcp_color tdcp_color9',
		                        'tdc_preset_individual' => '1',
		                        'accent_text_color' => '#4caf50',
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Columns',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_col',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 1
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col1',
		                        'tdc_preset_individual' => '1',
		                        "modules_on_row" => "",
		                        "modules_gap" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 2
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col2',
		                        'tdc_preset_individual' => '1',
		                        "modules_on_row" => "eyJhbGwiOiI1MCUiLCJwaG9uZSI6IjEwMCUifQ==",
		                        "modules_gap" => "eyJhbGwiOiIxLjYlIiwicG9ydHJhaXQiOiIyJSJ9",
		                        "limit" => "2",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 3
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col3',
		                        'tdc_preset_individual' => '1',
		                        "modules_on_row" => "eyJhbGwiOiIzMy4zMzMzMzMzMyUiLCJwaG9uZSI6IjEwMCUifQ==",
		                        "modules_gap" => "1.4%",
		                        "limit" => "3",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 4
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col4',
		                        'tdc_preset_individual' => '1',
		                        "modules_on_row" => "eyJhbGwiOiIyNSUiLCJwaG9uZSI6IjUwJSJ9",
		                        "modules_gap" => "eyJhbGwiOiIxLjIlIiwicGhvbmUiOiIzJSJ9",
		                        "limit" => "4",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Columns - 5
		                        'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col5',
		                        'tdc_preset_individual' => '1',
		                        "modules_on_row" => "eyJhbGwiOiIyMCUiLCJwaG9uZSI6IjEwMCUifQ==",
		                        "modules_gap" => "1%",
		                        "limit" => "5",
		                        "image_width" => "eyJwaG9uZSI6IjMwIn0=",
		                        "image_floated" => "eyJwaG9uZSI6ImZsb2F0X2xlZnQifQ==",
		                        "meta_padding" => "eyJwaG9uZSI6IjJweCAwIDAgMTZweCJ9",
		                        "all_modules_space" => "eyJhbGwiOiIzNiIsInBob25lIjoiMjUifQ==",
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Layout style',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_layout',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Layout style - normal
		                        'tdc_preset_class' => 'tdcp_img tdcp_layout tdcp_layout1',
		                        'tdc_preset_individual' => '1',
		                        "all_modules_space" => "",
		                        "image_width" => "",
		                        "image_floated" => "",
		                        "meta_padding" => "",
		                        "meta_padding2" => "",
		                        "image_radius" => "",
		                        "image_height" => "50",
		                        "meta_info_horiz" => "",
		                        "modules_category" => "image",
		                        "modules_category_margin" => "",
		                        "art_title_pos" => "bottom",
		                        "info_pos" => "bottom",
		                        "art_excerpt_pos" => "bottom",
		                        "art_excerpt" => "",
		                        "btn_pos" => "bottom"
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Layout style - normal
		                        'tdc_preset_class' => 'tdcp_img tdcp_layout tdcp_layout5',
		                        'tdc_preset_individual' => '1',
		                        "all_modules_space" => "48",
		                        "image_width" => "",
		                        "image_floated" => "",
		                        "image_radius" => "",
		                        "image_height" => "50",
		                        "meta_padding" => "0 0 20px",
		                        "meta_padding2" => "20px 0 0",
		                        "meta_info_horiz" => "content-horiz-center",
		                        "modules_category" => "above",
		                        "modules_category_margin" => "0 0 9px",
		                        "art_title_pos" => "top",
		                        "info_pos" => "top",
		                        "art_excerpt_pos" => "bottom",
		                        "art_excerpt" => "0",
		                        "btn_pos" => "bottom"
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Layout style - normal
		                        'tdc_preset_class' => 'tdcp_img tdcp_layout tdcp_layout6',
		                        'tdc_preset_individual' => '1',
		                        "all_modules_space" => "",
		                        "image_width" => "",
		                        "image_floated" => "",
		                        "meta_padding" => "0 0 11px",
		                        "meta_padding2" => "",
		                        "image_radius" => "",
		                        "image_height" => "50",
		                        "meta_info_horiz" => "",
		                        "modules_category" => "image",
		                        "modules_category_margin" => "",
		                        "art_title_pos" => "top",
		                        "info_pos" => "bottom",
		                        "art_excerpt_pos" => "bottom",
		                        "art_excerpt" => "",
		                        "btn_pos" => "bottom"
		                    ),

		                    array(
		                        'tdc_preset_name' => 'Show/Hide module elements',
		                        'tdc_preset_class' => 'tdcp_separator tdcp_separator_elements',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_cat" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_cat" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Category tag', // Category tag
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_author" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_author" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Author', // Author
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_date" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_date" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Date', // Author
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_review" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_review" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Review stars', // Review
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_com" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h',
		                        'tdc_preset_individual' => '1',
		                        "show_com" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Comment tag', // Comment tag
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h tdcp_clear',
		                        'tdc_preset_individual' => '1',
		                        "show_excerpt" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Excerpt', // Excerpt
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Show
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_s',
		                        'tdc_preset_individual' => '1',
		                        "show_btn" => "",
		                    ),
		                    array(
		                        'tdc_preset_name' => '', // Hide
		                        'tdc_preset_class' => 'tdcp_img tdcp_elements tdcp_elements_h tdcp_clear',
		                        'tdc_preset_individual' => '1',
		                        "show_btn" => "none",
		                    ),
		                    array(
		                        'tdc_preset_name' => 'Button', // Button
		                        'tdc_preset_class' => 'tdcp_elements_text',
		                    ),
		                )
		            )
		        ),
		        "params"                 => array_merge(
		            self::get_map_block_general_array(),

		            array(
                        array(
                            "param_name" => "title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H4' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H3' => 'h3',
                                'Div' => 'div'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/title_seo.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Content length',
		                    "value"      => "",
		                    "class"      => "",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module Flex 5',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                ),
		                array(
		                    "param_name"  => "mc5_tl",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Title length',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
		                ),
                        array(
                            "param_name" => "mc5_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
		                array(
		                    "param_name"  => "mc5_el",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Excerpt length',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "25",
                            "info_img" => "https://cloud.tagdiv.com/help/excerpt_length.png",
		                ),
		            ),

		            self::get_map_filter_array(),
		            self::get_map_block_ajax_filter_array(),

		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Layout',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "modules_on_row",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        '1'  => '100%',
		                        '2'  => '50%',
		                        '3'  => '33.33333333%',
		                        '4'  => '25%',
		                        '5'  => '20%',
		                        '6'  => '16.66666667%',
		                        '7'  => '14.28571428%',
		                        '8'  => '12.5%',
		                        '9'  => '11.11111111%',
		                        '10' => '10%',
		                    ),
		                    "heading"     => 'Modules per row',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-small",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
		                ),
		                array(
		                    "param_name"  => "modules_gap",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Modules gap',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "40",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
		                ),
		                array(
		                    "param_name"  => "m_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Modules padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
		                ),
		                array(
		                    "param_name"  => "all_modules_space",
		                    "type"        => "textfield-responsive",
		                    "value"       => '36',
		                    "heading"     => 'Modules bottom space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "36",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "modules_border_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
		                array(
		                    "param_name"  => "modules_divider",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'None'   => '',
		                        'Solid'  => 'solid',
		                        'Dotted' => 'dotted',
		                        'Dashed' => 'dashed',
		                    ),
		                    "heading"     => 'Modules divider',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_divider.png",
		                ),
                        array(
                            "param_name"  => "divider_on",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Show all dividers",
                            "description" => "Display dividers on modules from the last row",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_all_dividers.png",
                        ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Modules divider color',
		                    "param_name"  => "modules_divider_color",
		                    "value"       => '#eaeaea',
		                    "description" => '',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_divider_color.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
		                array(
		                    "param_name"  => "h_effect",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'None'   => '',
		                        'Shadow'  => 'shadow',
		                        'Move up & shadow'  => 'up-shadow',
		                    ),
		                    "heading"     => 'Hover effect',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hover_effect.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article image',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name"  => "image_size",
		                    "type"        => "dropdown",
		                    "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
		                    ),
		                    "heading"     => 'Image size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
		                ),
		                array(
		                    'param_name'  => 'image_alignment',
		                    'type'        => 'range-responsive',
		                    'value'       => '50',
		                    'heading'     => 'Image V alignment',
		                    'description' => '0 - Top / 50 - Center / 100 - Bottom',
		                    'class'       => 'tdc-textfield-small',
		                    'range_min'   => '0',
		                    'range_max'   => '100',
		                    'range_step'  => '1',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_v_alignment.png",
		                ),
		                array(
		                    "param_name"  => "image_height",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image height (percent)',
		                    "description" => "Default value in percent",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "50",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
		                ),
		                array(
		                    "param_name"  => "image_radius",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
		                ),
		                array(
		                    "param_name"  => "image_margin",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Image margin',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_margin.png",
		                ),
		                array(
		                    "param_name"  => "hide_image",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Hide image",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article video',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "video_icon",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video icon size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "video_popup",
                            "type"        => "checkbox",
                            "value"       => 'yes',
                            "heading"     => "Enable video pop-up",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_enable_video_pop-up.png",
                        ),
                        array(
                            "param_name" => "video_rec",
                            "type" => "textarea_raw_html",
                            "holder" => "div",
                            "class" => "tdc-textarea-raw-small",
                            "heading" => 'Video pop-up ad',
                            "value" => "",
                            "description" => 'Paste your ad code here.',
                            'group'      => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_popup_ad.png",
                        ),
                        array(
                            "param_name" => "spot_header",
                            "type" => "spot_header",
                            "value" => "",
                            "class" => '',
                            'group' => 'Layout',
                        ),
                        array(
                            "param_name" => "video_rec_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Ad title',
                            "description" => "",
                            "placeholder" => "- Advertisement -",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-spot-controller tdc-spot-title",
                            'group'      => 'Layout',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-spot-controller tdc-spot-color",
                            "heading"     => 'Ad title color',
                            "param_name"  => "video_rec_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "video_rec_disable",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Hide ADS for admins/editors",
                            "description" => "Used to prevent fake clicks and views on ads by admins and editors",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "show_vid_t",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show video duration',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_show_video_duration.png",
                        ),
                        array(
                            "param_name"  => "vid_t_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_space.png",
                        ),
                        array(
                            "param_name"  => "vid_t_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video duration padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 4px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Video pop-up article title color',
                            "param_name"  => "video_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_title_color.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Video pop-up article title hover color',
                            "param_name"  => "video_title_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "video_bg",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Video pop-up background color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_background.png",
                        ),
                        array(
                            "param_name" => "video_overlay",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Video pop-up overlay color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_overlay_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Layout',
                        ),
                        array(
                            "param_name" => "vid_t_color",
                            "holder"     => "div",
                            "type"       => "colorpicker",
                            'heading'    => "Video duration text color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_text_color.png",
                        ),
                        array(
                            "param_name" => "vid_t_bg_color",
                            "holder"     => "div",
                            "type"       => "colorpicker",
                            'heading'    => "Video duration background color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_bg_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Layout',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_vid_title', true, 'Video pop-up article title', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_article_title.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_vid_time', false, 'Video duration text', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_duration_title.png', '' ),
                    self::get_map_exclusive_label_array(),
                    array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article meta info',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Layout",
		                ),
		                array(
		                    "param_name" => "meta_info_horiz",
		                    "type" => "dropdown",
		                    "value" => array(
		                        'Left' => 'content-horiz-left',
		                        'Center' => 'content-horiz-center',
		                        'Right' => 'content-horiz-right'
		                    ),
		                    "heading" => 'Meta info horiz align',
		                    "description" => "",
		                    "holder" => "div",
		                    'tdc_dropdown_images' => true,
		                    "class" => "tdc-visual-selector tdc-add-class",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
		                ),
		                array(
		                    "param_name"  => "meta_width",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta info width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "100%",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
		                ),
		                array(
                            "param_name"  => "meta_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Top info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_top_margin.png",
                        ),
		                array(
                            "param_name"  => "meta_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Bottom info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "13px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_bottom_margin.png",
                        ),
		                array(
		                    "param_name"  => "meta_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Top info padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_top_padding.png",
		                ),
		                array(
		                    "param_name"  => "meta_padding2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Bottom info padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "13px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_bottom_padding.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Meta info border',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "meta_info_border_size",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Top info border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_top_border.png",
		                ),
		                array(
		                    "param_name"  => "meta_info_border_size2",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Bottom info border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_bottom_border.png",
		                ),
		                array(
		                    "param_name"  => "meta_info_border_style",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Solid'  => '',
		                        'Dotted' => 'dotted',
		                        'Dashed' => 'dashed',
		                    ),
		                    "heading"     => 'Border style',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_border_style.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Border color',
		                    "param_name"  => "meta_info_border_color",
		                    "value"       => '#eaeaea',
		                    "description" => '',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_border_color.png",
		                ),
                        array(
                            "param_name"  => "meta_info_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Top info border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "meta_info_border_radius2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Bottom info border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article title',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "art_title_pos",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Above image' => 'top',
		                        'Under image' => 'bottom',
		                    ),
		                    "heading"     => 'Article title position',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_title_position.png",
		                ),


		                array(
		                    "param_name"  => "info_pos",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Above image' => 'top',
		                        'Under image' => 'bottom',
		                        'Above title' => 'title',
		                    ),
		                    "heading"     => 'Info position',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_info_position.png",
		                ),
		                array(
		                    "param_name"  => "info_space",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Info space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_info_space.png",
		                ),

		                array(
		                    "param_name"  => "art_title",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Article title space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 6px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article excerpt',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "show_excerpt",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show excerpt',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
		                ),
		                array(
		                    "param_name"  => "art_excerpt_pos",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Above image' => 'top',
		                        'Under image' => 'bottom',
		                    ),
		                    "heading"     => 'Article excerpt position',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_excerpt_position.png",
		                ),
		                array(
		                    "param_name"  => "art_excerpt",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Article excerpt space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "20px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_excerpt_space.png",
		                ),
		                array(
		                    "param_name"  => "excerpt_inline",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Inline Excerpt & Title",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_inline_excerpt_title.png",
		                ),
		                array(
		                    "param_name"  => "meta_space",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Meta container space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_container_space.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article audio player',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "show_audio",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Visible' => 'block',
                                'Hidden' => 'none',
                            ),
                            "heading"     => 'Show audio player',
                            "description" => "This will hide the audio player responsive",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name"  => "hide_audio",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Remove audio player",
                            "description" => "This will remove the audio player from code",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name"  => "art_audio_pos",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Above image' => 'top',
                                'Under image' => 'bottom',
                            ),
                            "heading"     => 'Audio player position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_position.png",
                        ),
                        array(
                            "param_name"  => "art_audio",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Audio player space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_space.png",
                        ),
                        array(
                            'param_name'  => 'art_audio_size',
                            'type'        => 'range-responsive',
                            'value'       => '1.5',
                            'heading'     => 'Audio player size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_size.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Category tag',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "show_cat",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show category',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
		                ),
		                array(
		                    "param_name"  => "modules_category",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Inline'      => '',
		                        'Above title' => 'above',
		                        'Over image'  => 'image',
		                    ),
		                    "heading"     => 'Category tag position',
		                    "description" => "Float image",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
		                ),
		                array(
		                    "param_name"  => "modules_category_margin",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category tag spacing',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_spacing.png",
		                ),
		                array(
		                    "param_name"  => "modules_category_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category tag padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "3px 6px 4px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
		                ),
		                array(
		                    "param_name"  => "modules_category_border",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Category tag border',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 0px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_border.png",
		                ),
		                array(
		                    'param_name'  => 'modules_category_radius',
		                    'type'        => 'range-responsive',
		                    'value'       => '0',
		                    'heading'     => 'Border radius',
		                    'description' => '',
		                    'class'       => 'tdc-textfield-small',
		                    'range_min'   => '0',
		                    'range_max'   => '100',
		                    'range_step'  => '1',
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_radius.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Author',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "show_author",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show author',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
		                ),
		                array(
		                    "param_name"  => "author_photo",
		                    "type"        => "checkbox",
		                    "value"       => '',
		                    "heading"     => "Show author photo",
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_size",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "20",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_size.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_space",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "6",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_space.png",
		                ),
		                array(
		                    "param_name"  => "author_photo_radius",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Author photo radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "50%",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_radius.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Date / Comment',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "show_date",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'inline-block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show date',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
		                ),
		                array(
		                    "param_name"  => "show_com",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show comment',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_show.png",
		                ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review stars',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "show_review",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show review stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
                        ),
                        array(
                            "param_name"  => "review_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'review_size',
                            'type'        => 'range-responsive',
                            'value'       => '2.5',
                            'heading'     => 'Review stars size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name"  => "review_distance",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Distance between rating stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Button',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name"  => "show_btn",
		                    "type"        => "dropdown-responsive",
		                    "value"       => array(
		                        'Show' => 'block',
		                        'Hide' => 'none',
		                    ),
		                    "heading"     => 'Show button',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_show.png",
		                ),
		                array(
		                    "param_name"  => "btn_pos",
		                    "type"        => "dropdown",
		                    "value"       => array(
		                        'Above image' => 'top',
		                        'Under image' => 'bottom',
		                    ),
		                    "heading"     => 'Button position',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-dropdown-big",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_position.png",
		                ),
		                array(
		                    "param_name"  => "btn_title",
		                    "type"        => "textfield",
		                    "value"       => '',
		                    "heading"     => 'Button text',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "Read more",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_text.png",
		                ),
		                array(
		                    "param_name"  => "btn_margin",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Button space',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "0px 0px 20px 0px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_space.png",
		                ),
		                array(
		                    "param_name"  => "btn_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Button padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "10px 15px",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_padding.png",
		                ),
		                array(
		                    "param_name"  => "btn_border_width",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Button border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_border.png",
		                ),
		                array(
		                    "param_name"  => "btn_radius",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Button radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_radius.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Pagination',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"       => 'Layout'
		                ),
		                array(
		                    "param_name" => "pag_space",
		                    "type" => "textfield",
		                    "value" => '',
		                    "heading" => 'Top space',
		                    "description" => "",
		                    "placeholder" => "20",
		                    "holder" => "div",
		                    "class" => "tdc-textfield-small",
		                    'group'      => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_space.png",
		                ),
		                array(
		                    "param_name"  => "pag_padding",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Padding',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-big",
		                    "placeholder" => "",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_padding.png",
		                ),
		                array(
		                    "param_name"  => "pag_border_width",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Border width',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "1",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_border.png",
		                ),
		                array(
		                    "param_name"  => "pag_border_radius",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Border radius',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_border_radius.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type" => "horizontal_separator",
		                    "value" => "",
		                    "class" => "tdc-separator-small",
		                    "group" => 'Layout',
		                ),
		                array(
		                    'param_name' => 'prev_tdicon',
		                    'type' => 'icon',
		                    'heading' => 'Prev icon',
		                    'class' => 'tdc-textfield-small',
		                    'value' => '',
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow.png",
		                ),
		                array(
		                    'param_name' => 'next_tdicon',
		                    'type' => 'icon',
		                    'heading' => 'Next icon',
		                    'class' => 'tdc-textfield-small',
		                    'value' => '',
		                    "group"       => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow.png",
		                ),
		                array(
		                    "param_name"  => "pag_icons_size",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Icons size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "",
		                    "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_arrow_size.png",
		                ),

		                array(
		                    "param_name" => "separator",
		                    "type" => "text_separator",
		                    'heading' => 'Block fonts',
		                    "value" => "",
		                    "class" => "",
		                    "group" => 'Style',
		                ),
		            ),
		            td_config_helper::get_map_block_font_array( 'f_header', true, 'Block header', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_block_header.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_ajax', false, 'Ajax categories', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_ajax.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_more', false, 'Load more button', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_load_more.png', '' ),
		            array(
		                array(
		                    "param_name" => "separator",
		                    "type" => "text_separator",
		                    'heading' => 'Module fonts',
		                    "value" => "",
		                    "class" => "",
		                    "group" => 'Style',
		                ),
		            ),
		            td_config_helper::get_map_block_font_array( 'f_title', true, 'Article title', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_cat', false, 'Article category tag', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_meta', false, 'Article meta info', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_ex', false, 'Article excerpt', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_excerpt.png', '' ),
		            td_config_helper::get_map_block_font_array( 'f_btn', false, 'Article read more button', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_read.png', '' ),
                    td_config_helper::mix_blend(),
                    td_config_helper::image_filters(),

		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Colors',
		                    "value"      => "",
		                    "class"      => "",
		                    "group"      => "Style",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Module',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Module background',
		                    "param_name"  => "m_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "horizontal_separator",
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		            ),
		            td_config_helper::get_map_block_shadow_array('shadow', 'Module Shadow', 0, 0, 0, "Style", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_shadow.png', '' ),
		            array(
		                array(
		                    "param_name" => "separator",
		                    "type"       => "horizontal_separator",
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Top meta info background',
		                    "param_name"  => "meta_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Bottom meta info background',
		                    "param_name"  => "meta_bg2",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Article title',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Article title text color',
		                    "param_name"  => "title_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_article_title.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Article title text hover',
		                    "param_name"  => "title_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name"  => "all_underline_height",
		                    "type"        => "textfield-responsive",
		                    "value"       => '',
		                    "heading"     => 'Underline size',
		                    "description" => "",
		                    "holder"      => "div",
		                    "class"       => "tdc-textfield-small",
		                    "placeholder" => "0",
		                    "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/style_underline.png",
		                ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Hover underline color',
                            "param_name"  => "all_underline_color",
                            "value"       => '#000',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_underline_color.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Category tag',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category background',
		                    "param_name"  => "cat_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category background hover',
		                    "param_name"  => "cat_bg_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category text color',
		                    "param_name"  => "cat_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category text hover',
		                    "param_name"  => "cat_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Category border color',
		                    "param_name"  => "cat_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_border.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Category border hover',
		                    "param_name"  => "cat_border_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'AUTHOR / DATE / COMMENT / EXCERPT',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Author text color',
		                    "param_name"  => "author_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Author text hover',
		                    "param_name"  => "author_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Date text color',
		                    "param_name"  => "date_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Excerpt text color',
		                    "param_name"  => "ex_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_excerpt.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Comment background',
		                    "param_name"  => "com_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "",
		                    "heading"     => 'Comment text color',
		                    "param_name"  => "com_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_text.png",
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "horizontal_separator",
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		            ),
		            td_config_helper::get_map_block_shadow_array('shadow_m', 'Meta info shadow', 0, 0, 0, "Style", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_meta_shadow.png', '' ),
		            array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Audio player',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Buttons color',
                            "param_name"  => "audio_btn_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_buttons.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Time text color',
                            "param_name"  => "audio_time_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_time.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Bars background color',
                            "param_name"  => "audio_bar_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_bar.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Bars progress color',
                            "param_name"  => "audio_bar_curr_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_progress.png",
                        ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Button',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Button background',
		                    "param_name"  => "btn_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_color_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Button background hover',
		                    "param_name"  => "btn_bg_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Button text color',
		                    "param_name"  => "btn_txt",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_color_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Button text hover',
		                    "param_name"  => "btn_txt_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Button border color',
		                    "param_name"  => "btn_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_border_color.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Button border hover',
		                    "param_name"  => "btn_border_hover",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "param_name" => "separator",
		                    "type"       => "text_separator",
		                    'heading'    => 'Pagination',
		                    "value"      => "",
		                    "class"      => "tdc-separator-small",
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Text color',
		                    "param_name"  => "pag_text",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_color_text.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Text hover color',
		                    "param_name"  => "pag_h_text",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Background color',
		                    "param_name"  => "pag_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_color_bg.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Background hover color',
		                    "param_name"  => "pag_h_bg",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-a",
		                    "heading"     => 'Border color',
		                    "param_name"  => "pag_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_pagination_color_border.png",
		                ),
		                array(
		                    "type"        => "colorpicker",
		                    "holder"      => "div",
		                    "class"       => "td-colorpicker-double-b",
		                    "heading"     => 'Border hover color',
		                    "param_name"  => "pag_h_border",
		                    "value"       => '',
		                    "description" => '',
		                    "group"       => 'Style',
		                ),
		            ),
		            self::get_map_block_pagination_array()
		        )
		    )
		);


		/**
         * the big grids
         */
        td_api_block::add('td_block_big_grid_flex_1',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 1',
                "base" => 'td_block_big_grid_flex_1',
                "class" => 'td_block_big_grid_flex_1',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_1',
                'file' => TDC_PATH_LEGACY . '/includes/shortcodes/td_block_big_grid_flex_1.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'grid_layout',
                    'image_height',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "grid_layout" => "2",
                                "image_height" => "eyJhbGwiOiI4NSIsInBob25lIjoiODAifQ==",
                                "image_zoom" => "yes",
                                "meta_info_vert" => "content-vert-bottom",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "f_title_font_size" => "eyJsYW5kc2NhcGUiOiIyMiIsInBvcnRyYWl0IjoiMTYiLCJwaG9uZSI6IjIyIn0=",
                                "f_title_font_line_height" => "eyJsYW5kc2NhcGUiOiIyOHB4IiwicG9ydHJhaXQiOiIyMHB4IiwicGhvbmUiOiIyOHB4In0=",
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
                                "f_title_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
                                "f_title_font_line_height" => "1.4",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title_font_size" => "eyJhbGwiOiIyMSIsImxhbmRzY2FwZSI6IjIwIiwicG9ydHJhaXQiOiIxNyJ9",
                                "f_title_font_line_height" => "1.2",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title_font_size" => "eyJhbGwiOiIyNiIsImxhbmRzY2FwZSI6IjI1IiwicG9ydHJhaXQiOiIyMSIsInBob25lIjoiMjEifQ==",
                                "f_title_font_line_height" => "1.2",

                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
                                "f_title_font_line_height" => "1.2",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
                                "f_title_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
                            ),

                            array(
                                'tdc_preset_name' => 'Text vertical alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align_v',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - top
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v1',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-top",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - middle
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v2',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - bottom
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v3',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-bottom",
                            ),

                            array(
                                'tdc_preset_name' => 'Grid height',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_grid_height',
                            ),
                            array(
                                'tdc_preset_name' => '', // Grid height - 2:3
                                'tdc_preset_class' => 'tdcp_img tdcp_grid_height tdcp_grid_height1',
                                'tdc_preset_individual' => '1',
                                "image_height" => "150",
                                "hide_image" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Image format - 3:4
                                'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_grid_height2',
                                'tdc_preset_individual' => '1',
                                "image_height" => "133",
                                "hide_image" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Grid height - 7:8
                                'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_grid_height3',
                                'tdc_preset_individual' => '1',
                                "image_height" => "114",
                                "hide_image" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Grid height - 1:1
                                'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_grid_height4',
                                'tdc_preset_individual' => '1',
                                "image_height" => "100",
                                "hide_image" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Grid height - 4:3
                                'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_grid_height5',
                                'tdc_preset_individual' => '1',
                                "image_height" => "75",
                                "hide_image" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Grid height - 16:9
                                'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_grid_height6',
                                'tdc_preset_individual' => '1',
                                "image_height" => "56",
                                "hide_image" => "",
                            ),

                            array(
                                'tdc_preset_name' => 'Columns',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_col',
                            ),
                            array(
                                'tdc_preset_name' => '', // Columns - 1
                                'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col1',
                                'tdc_preset_individual' => '1',
                                "grid_layout" => "1",
                                "image_height" => "eyJhbGwiOiI1MCIsInBob25lIjoiNzAifQ==",
                            ),
                            array(
                                'tdc_preset_name' => '', // Columns - 2
                                'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col2',
                                'tdc_preset_individual' => '1',
                                "grid_layout" => "2",
                                "image_height" => "eyJhbGwiOiI4NSIsInBob25lIjoiODAifQ==",
                            ),
                            array(
                                'tdc_preset_name' => '', // Columns - 3
                                'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col3',
                                'tdc_preset_individual' => '1',
                                "grid_layout" => "3",
                                "image_height" => "eyJhbGwiOiI4NSIsInBob25lIjoiODAifQ==",
                            ),
                            array(
                                'tdc_preset_name' => '', // Columns - 4
                                'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col4',
                                'tdc_preset_individual' => '1',
                                "grid_layout" => "4",
                                "image_height" => "eyJhbGwiOiIxMjAiLCJwaG9uZSI6IjUwIn0=",
                            ),
                            array(
                                'tdc_preset_name' => '', // Columns - 5
                                'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col5',
                                'tdc_preset_individual' => '1',
                                "grid_layout" => "5",
                                "image_height" => "eyJhbGwiOiIxMjAiLCJwaG9uZSI6IjUwIn0=",
                            ),

                            array(
                                'tdc_preset_name' => 'Style',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_style',
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 1 - default
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style1',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "overlay_h_general" => "",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 2 - colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style2',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjYpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuNikscmdiYSgxOTgsNTcsNTcsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC41OSkiLCJjb2xvcjIiOiJyZ2JhKDIxNSw5NiwxODMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTQ1ZGVnLHJnYmEoMjE1LDk2LDE4MywwLjYpLHJnYmEoNTksMTIwLDE4MCwwLjU5KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkifQ==",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC42KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjYpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC42KSxyZ2JhKDI0MiwxMjIsNTMsMC42KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 3 - flat colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style3',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjgpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuOCkscmdiYSgxOTgsNTcsNTcsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC44KSIsImNvbG9yMiI6InJnYmEoMjE1LDk2LDE4MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC44KSxyZ2JhKDU5LDEyMCwxODAsMC44KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC44KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC44KSxyZ2JhKDI0MiwxMjIsNTMsMC44KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 4 - light sky
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style4',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "rgba(0,0,0,0.7)",
                                "overlay_h_general" => "rgba(77,178,236,0.3)",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "lightsky" => "yes",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 5 - rainbow
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style5',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDExMiwyNTUsMTUzLDAuNikiLCJjb2xvcjIiOiJyZ2JhKDI0NCwxMzYsMTMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMjQ0LDEzNiwxMywwLjYpLHJnYmEoMTEyLDI1NSwxNTMsMC42KSJ9",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDEyNiwxOTEsMjU1LDAuNikiLCJjb2xvcjIiOiJyZ2JhKDE5NiwxNSwxMjEsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMTk2LDE1LDEyMSwwLjYpLHJnYmEoMTI2LDE5MSwyNTUsMC42KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDQyLDIzNiwxMTYsMC42KSIsImNvbG9yMiI6InJnYmEoMCwyMiwxOTAsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMCwyMiwxOTAsMC42KSxyZ2JhKDQyLDIzNiwxMTYsMC42KSJ9",
                                "lightsky" => "",
                            ),
                        )
                    )
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                        ),
                        array(
                            "param_name" => "mf6_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    array(
                        array(
                            "param_name" => "grid_layout",
                            "type" => "dropdown",
                            "value" => array(
                                '1 column'  => '1',
                                '2 columns' => '2',
                                '3 columns' => '3',
                                '4 columns' => '4',
                                '5 columns' => '5',
                            ),
                            "heading" => 'Grid layout',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-cat-grid-layout tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "container_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Container width (0-100 percent)',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_container.png",
                        ),
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '4',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "20",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article image',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
                        array(
                            'param_name'  => 'image_alignment',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_v_alignment.png",
                        ),
                        array(
                            "param_name"  => "image_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name"  => "video_icon",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video icon size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name"  => "video_icon_pos",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Center'  => 'center',
                                'Corner' => 'corner',
                            ),
                            "heading"     => 'Video icon position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_zoom",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Zoom effect on hover",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article meta info',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
                        ),
                        array(
                            "param_name" => "meta_info_vert",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-vert-top',
                                'Center' => 'content-vert-center',
                                'Right' => 'content-vert-bottom'
                            ),
                            "heading" => 'Meta info vert align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
                        ),
                        array(
                            "param_name"  => "meta_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
                        ),
                        array(
                            "param_name"  => "meta_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "22px 20px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
                        ),
                        array(
                            "param_name"  => "art_title_padd",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_top_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
                        ),
                        array(
                            "param_name"  => "modules_category_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 5px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_spacing.png",
                        ),
                        array(
                            "param_name"  => "modules_category_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
                        ),
                        array(
                            "param_name"  => "modules_cat_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_border.png",
                        ),
                        array(
                            'param_name'  => 'modules_category_radius',
                            'type'        => 'range-responsive',
                            'value'       => '0',
                            'heading'     => 'Border radius',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_radius.png",
                        ),
                        array(
                            "param_name"  => "show_cat",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
                        ),
                        array(
                            "param_name"  => "show_date",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
                        ),
                        array(
                            "param_name"  => "auth_date_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_review",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show review stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
                        ),
                        array(
                            "param_name"  => "review_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'review_size',
                            'type'        => 'range-responsive',
                            'value'       => '2.5',
                            'heading'     => 'Review stars size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name"  => "review_distance",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Distance between rating stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Module fonts',
                            "value" => "",
                            "class" => "",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title', true, 'Article title', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_cat', false, 'Article category tag', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_meta', false, 'Article meta info', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', '' ),
                    td_config_helper::mix_blend(),
                    td_config_helper::image_filters(),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_h_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay hover color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_1",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 1",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_2",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 2",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_3",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 3",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_4",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 4",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name"  => "lightsky",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Lightsky",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta info background',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
                        ),
                        array(
                            "param_name"  => "meta_shadow",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Meta info shadow off",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Article title text color',
                            "param_name"  => "title_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_article_title.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Article title text hover',
                            "param_name"  => "title_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title background color',
                            "param_name"  => "title_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name"  => "all_underline_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Underline size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/style_underline.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Hover underline color',
                            "param_name"  => "all_underline_color",
                            "value"       => '#000',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_underline_color.png",
                        ),
                        array(
                            "param_name"  => "title_shadow",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Article title shadow off",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Category background',
                            "param_name"  => "cat_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_bg.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Category background hover',
                            "param_name"  => "cat_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Category text color',
                            "param_name"  => "cat_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_text.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Category text hover',
                            "param_name"  => "cat_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Category border color',
                            "param_name"  => "cat_border",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_border.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Category border hover',
                            "param_name"  => "cat_border_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Author text color',
                            "param_name"  => "author_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_color.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Author text hover',
                            "param_name"  => "author_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date text color',
                            "param_name"  => "date_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_color.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author & date background color',
                            "param_name"  => "auth_date_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review stars color',
                            "param_name"  => "review_stars",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                    ),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_flex_2',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 2',
                "base" => 'td_block_big_grid_flex_2',
                "class" => 'td_block_big_grid_flex_2',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_2',
                'file' => TDC_PATH_LEGACY . '/includes/shortcodes/td_block_big_grid_flex_2.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "meta_info_vert" => "content-vert-bottom",
                                "image_zoom" => "yes",
                                "show_author2" => "none",
                                "show_date2" => "none",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "image_height2" => "eyJsYW5kc2NhcGUiOiIxNzNweCIsInBob25lIjoiMTY1cHgiLCJwb3J0cmFpdCI6IjEzM3B4In0=",
                                "image_height1" => "eyJwaG9uZSI6IjI2MHB4IiwibGFuZHNjYXBlIjoiMzUwcHgiLCJwb3J0cmFpdCI6IjI3MHB4In0=",
                                "modules_gap" => "eyJwaG9uZSI6IjMifQ==",
                                "meta_padding2" => "eyJsYW5kc2NhcGUiOiIxNnB4IDE1cHggMTFweCIsInBvcnRyYWl0IjoiMTZweCAxNXB4IDExcHgiLCJwaG9uZSI6IjE2cHggMTVweCAxMXB4In0=",
                                "meta_padding1" => "eyJwaG9uZSI6IjE1cHggMThweCJ9",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "image_size2" => "td_324x400",
                                "image_size" => "",
                                "image_width1" => "eyJwaG9uZSI6IjEwMCJ9",
                                "image_width2" => "eyJwaG9uZSI6IjgwIn0=",
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "394",
                                "f_title2_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title1_font_family" =>        "721",
                                "f_title2_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "507",
                                "f_title2_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "653",
                                "f_title2_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "147",
                                "f_title2_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "445",
                                "f_title2_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "406",
                                "f_title2_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "646",
                                "f_title2_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "41",
                                "f_title2_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "502",
                                "f_title2_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "331",
                                "f_title2_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "663",
                                "f_title2_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "639",
                                "f_title2_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "",
                                "f_title2_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
                                "f_title1_font_line_height" => "1.4",
                                "f_title2_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
                                "f_title2_font_line_height" => "1.4",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyMSIsImxhbmRzY2FwZSI6IjIwIiwicG9ydHJhaXQiOiIxNyJ9",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTMifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyNiIsImxhbmRzY2FwZSI6IjI1IiwicG9ydHJhaXQiOiIyMSIsInBob25lIjoiMjEifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",

                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
                                "f_title1_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
                                "f_title2_font_size" => "eyJhbGwiOiIxOCIsImxhbmRzY2FwZSI6IjE3IiwicG9ydHJhaXQiOiIxNiIsInBob25lIjoiMTYifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
                            ),

                            array(
                                'tdc_preset_name' => 'Text vertical alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align_v',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - top
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v1',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-top",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - middle
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v2',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - bottom
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v3',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-bottom",
                            ),

                            array(
                                'tdc_preset_name' => 'Style',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_style',
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 1 - default
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style1',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "overlay_h_general" => "",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "overlay_5" => "",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 2 - colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style2',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjYpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuNikscmdiYSgxOTgsNTcsNTcsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC41OSkiLCJjb2xvcjIiOiJyZ2JhKDIxNSw5NiwxODMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTQ1ZGVnLHJnYmEoMjE1LDk2LDE4MywwLjYpLHJnYmEoNTksMTIwLDE4MCwwLjU5KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkifQ==",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC42KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjYpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC42KSxyZ2JhKDI0MiwxMjIsNTMsMC42KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 3 - flat colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style3',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjgpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuOCkscmdiYSgxOTgsNTcsNTcsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC44KSIsImNvbG9yMiI6InJnYmEoMjE1LDk2LDE4MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC44KSxyZ2JhKDU5LDEyMCwxODAsMC44KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC44KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC44KSxyZ2JhKDI0MiwxMjIsNTMsMC44KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 4 - light sky
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style4',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "rgba(0,0,0,0.7)",
                                "overlay_h_general" => "rgba(77,178,236,0.3)",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "overlay_5" => "",
                                "lightsky" => "yes",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 5 - rainbow
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style5',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDExMiwyNTUsMTUzLDAuNikiLCJjb2xvcjIiOiJyZ2JhKDI0NCwxMzYsMTMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMjQ0LDEzNiwxMywwLjYpLHJnYmEoMTEyLDI1NSwxNTMsMC42KSJ9",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDEyNiwxOTEsMjU1LDAuNikiLCJjb2xvcjIiOiJyZ2JhKDE5NiwxNSwxMjEsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMTk2LDE1LDEyMSwwLjYpLHJnYmEoMTI2LDE5MSwyNTUsMC42KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDQyLDIzNiwxMTYsMC42KSIsImNvbG9yMiI6InJnYmEoMCwyMiwxOTAsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMCwyMiwxOTAsMC42KSxyZ2JhKDQyLDIzNiwxMTYsMC42KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "lightsky" => "",
                            ),
                        )
                    )
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                        ),
                        array(
                            "param_name" => "mf6_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 7',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf7_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                        ),
                        array(
                            "param_name" => "mf7_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    array(
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "4",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
                        ),
                        array(
                            "param_name" => "meta_info_vert",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-vert-top',
                                'Center' => 'content-vert-center',
                                'Right' => 'content-vert-bottom'
                            ),
                            "heading" => 'Meta info vert align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_zoom",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Zoom effect on hover",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 1',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
                        array(
                            'param_name'  => 'image_alignment1',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_v_alignment.png",
                        ),
                        array(
                            "param_name"  => "image_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "70",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
                        array(
                            "param_name"  => "image_height1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "400px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name"  => "video_icon1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video icon size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name"  => "video_icon_pos1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Center'  => 'center',
                                'Corner' => 'corner',
                            ),
                            "heading"     => 'Video icon position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
                        ),
                        array(
                            "param_name"  => "meta_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
                        ),
                        array(
                            "param_name"  => "meta_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "22px 20px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
                        ),
                        array(
                            "param_name"  => "art_title_padd1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_top_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 5px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_spacing.png",
                        ),
                        array(
                            "param_name"  => "modules_category_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
                        ),
                        array(
                            "param_name"  => "show_cat1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
                        ),
                        array(
                            "param_name"  => "show_date1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
                        ),
                        array(
                            "param_name"  => "auth_date_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_review1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show review stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
                        ),
                        array(
                            "param_name"  => "review_space1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'review_size1',
                            'type'        => 'range-responsive',
                            'value'       => '2.5',
                            'heading'     => 'Review stars size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name"  => "review_distance1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Distance between rating stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 2',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size2",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
                        array(
                            'param_name'  => 'image_alignment2',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_v_alignment.png",
                        ),
                        array(
                            "param_name"  => "image_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "30",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
                        array(
                            "param_name"  => "image_height2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "198px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name"  => "video_icon2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video icon size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name"  => "video_icon_pos2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Center'  => 'center',
                                'Corner' => 'corner',
                            ),
                            "heading"     => 'Video icon position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
                        ),
                        array(
                            "param_name"  => "meta_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
                        ),
                        array(
                            "param_name"  => "meta_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "11px 17px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
                        ),
                        array(
                            "param_name"  => "art_title_padd2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_top_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 7px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_spacing.png",
                        ),
                        array(
                            "param_name"  => "modules_category_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
                        ),
                        array(
                            "param_name"  => "show_cat2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
                        ),
                        array(
                            "param_name"  => "show_date2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
                        ),
                        array(
                            "param_name"  => "auth_date_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_review2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show review stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
                        ),
                        array(
                            "param_name"  => "review_space2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'review_size2',
                            'type'        => 'range-responsive',
                            'value'       => '2.5',
                            'heading'     => 'Review stars size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name"  => "review_distance2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Distance between rating stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Module fonts',
                            "value" => "",
                            "class" => "",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title1', true, 'Module 1 title', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_cat1', false, 'Module 1 category tag', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_meta1', false, 'Module 1 meta info', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_title2', false, 'Module 2 title', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_cat2', false, 'Module 2 category tag', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_meta2', false, 'Module 2 meta info', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', '' ),
                    td_config_helper::mix_blend(),
                    td_config_helper::image_filters(),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay color",
                            "value" => "",
                            "class" => "td-colorpicker-double-a",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_h_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay hover color",
                            "value" => "",
                            "class" => "td-colorpicker-double-b",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_1",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 1",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_2",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 2",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_3",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 3",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_4",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 4",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_5",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 5",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name"  => "lightsky",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Lightsky",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta info background',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
                        ),
                        array(
                            "param_name"  => "meta_shadow",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Meta info shadow off",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Article title text color',
                            "param_name"  => "title_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_article_title.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Article title text hover',
                            "param_name"  => "title_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title background color',
                            "param_name"  => "title_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name"  => "all_underline_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Underline size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Style",
                            "info_img" => "https://cloud.tagdiv.com/help/style_underline.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Hover underline color',
                            "param_name"  => "all_underline_color",
                            "value"       => '#000',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_underline_color.png",
                        ),
                        array(
                            "param_name"  => "title_shadow",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Article title shadow off",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Category background',
                            "param_name"  => "cat_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_bg.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Category background hover',
                            "param_name"  => "cat_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Category text color',
                            "param_name"  => "cat_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_text.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Category text hover',
                            "param_name"  => "cat_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Author text color',
                            "param_name"  => "author_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_color.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Author text hover',
                            "param_name"  => "author_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date text color',
                            "param_name"  => "date_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_color.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author & date background color',
                            "param_name"  => "auth_date_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review stars color',
                            "param_name"  => "review_stars",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                    ),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_flex_3',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 3',
                "base" => 'td_block_big_grid_flex_3',
                "class" => 'td_block_big_grid_flex_3',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_3',
                'file' => TDC_PATH_LEGACY . '/includes/shortcodes/td_block_big_grid_flex_3.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "meta_info_vert" => "content-vert-bottom",
                                "image_zoom" => "yes",
                                "show_author2" => "none",
                                "show_date2" => "none",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "image_height2" => "eyJwaG9uZSI6IjE2NXB4IiwibGFuZHNjYXBlIjoiMTQ1cHgiLCJwb3J0cmFpdCI6IjEwOXB4In0=",
                                "image_height1" => "eyJwaG9uZSI6IjI2MHB4IiwibGFuZHNjYXBlIjoiNDQzcHgiLCJwb3J0cmFpdCI6IjMzNXB4In0=",
                                "modules_gap" => "eyJwaG9uZSI6IjMifQ==",
                                "meta_padding2" => "eyJsYW5kc2NhcGUiOiIxNnB4IDE1cHggMTFweCIsInBvcnRyYWl0IjoiMTZweCAxNXB4IDExcHgiLCJwaG9uZSI6IjE2cHggMTVweCAxMXB4In0=",
                                "meta_padding1" => "eyJwaG9uZSI6IjE1cHggMThweCJ9",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "image_size" => "",
                                "image_size2" => "td_324x400",
                                "image_width1" => "eyJwaG9uZSI6IjEwMCJ9",
                                "image_width2" => "eyJwaG9uZSI6IjgwIn0=",
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "394",
                                "f_title2_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title1_font_family" =>        "721",
                                "f_title2_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "507",
                                "f_title2_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "653",
                                "f_title2_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "147",
                                "f_title2_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "445",
                                "f_title2_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "406",
                                "f_title2_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "646",
                                "f_title2_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "41",
                                "f_title2_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "502",
                                "f_title2_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "331",
                                "f_title2_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "663",
                                "f_title2_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "639",
                                "f_title2_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "",
                                "f_title2_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
                                "f_title1_font_line_height" => "1.4",
                                "f_title2_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
                                "f_title2_font_line_height" => "1.4",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyMSIsImxhbmRzY2FwZSI6IjIwIiwicG9ydHJhaXQiOiIxNyJ9",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTMifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyNiIsImxhbmRzY2FwZSI6IjI1IiwicG9ydHJhaXQiOiIyMSIsInBob25lIjoiMjEifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",

                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
                                "f_title1_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
                                "f_title2_font_size" => "eyJhbGwiOiIxOCIsImxhbmRzY2FwZSI6IjE3IiwicG9ydHJhaXQiOiIxNiIsInBob25lIjoiMTYifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
                            ),

                            array(
                                'tdc_preset_name' => 'Text vertical alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align_v',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - top
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v1',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-top",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - middle
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v2',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - bottom
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v3',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-bottom",
                            ),

                            array(
                                'tdc_preset_name' => 'Style',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_style',
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 1 - default
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style1',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "overlay_h_general" => "",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 2 - colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style2',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjYpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuNikscmdiYSgxOTgsNTcsNTcsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC41OSkiLCJjb2xvcjIiOiJyZ2JhKDIxNSw5NiwxODMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTQ1ZGVnLHJnYmEoMjE1LDk2LDE4MywwLjYpLHJnYmEoNTksMTIwLDE4MCwwLjU5KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkifQ==",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC42KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjYpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC42KSxyZ2JhKDI0MiwxMjIsNTMsMC42KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 3 - flat colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style3',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjgpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuOCkscmdiYSgxOTgsNTcsNTcsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC44KSIsImNvbG9yMiI6InJnYmEoMjE1LDk2LDE4MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC44KSxyZ2JhKDU5LDEyMCwxODAsMC44KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC44KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC44KSxyZ2JhKDI0MiwxMjIsNTMsMC44KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 4 - light sky
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style4',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "rgba(0,0,0,0.7)",
                                "overlay_h_general" => "rgba(77,178,236,0.3)",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "lightsky" => "yes",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 5 - rainbow
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style5',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDExMiwyNTUsMTUzLDAuNikiLCJjb2xvcjIiOiJyZ2JhKDI0NCwxMzYsMTMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMjQ0LDEzNiwxMywwLjYpLHJnYmEoMTEyLDI1NSwxNTMsMC42KSJ9",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDEyNiwxOTEsMjU1LDAuNikiLCJjb2xvcjIiOiJyZ2JhKDE5NiwxNSwxMjEsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMTk2LDE1LDEyMSwwLjYpLHJnYmEoMTI2LDE5MSwyNTUsMC42KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDQyLDIzNiwxMTYsMC42KSIsImNvbG9yMiI6InJnYmEoMCwyMiwxOTAsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMCwyMiwxOTAsMC42KSxyZ2JhKDQyLDIzNiwxMTYsMC42KSJ9",
                                "lightsky" => "",
                            ),
                        )
                    )
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                        ),
                        array(
                            "param_name" => "mf6_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 7',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf7_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                        ),
                        array(
                            "param_name" => "mf7_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    array(
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "4",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
                        ),
                        array(
                            "param_name" => "meta_info_vert",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-vert-top',
                                'Center' => 'content-vert-center',
                                'Right' => 'content-vert-bottom'
                            ),
                            "heading" => 'Meta info vert align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_zoom",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Zoom effect on hover",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 1',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
                        array(
                            'param_name'  => 'image_alignment1',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_v_alignment.png",
                        ),
                        array(
                            "param_name"  => "image_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "70",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
                        array(
                            "param_name"  => "image_height1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "482px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name"  => "video_icon1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video icon size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name"  => "video_icon_pos1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Center'  => 'center',
                                'Corner' => 'corner',
                            ),
                            "heading"     => 'Video icon position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
                        ),
                        array(
                            "param_name"  => "meta_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
                        ),
                        array(
                            "param_name"  => "meta_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "22px 20px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
                        ),
                        array(
                            "param_name"  => "art_title_padd1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_top_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 5px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_spacing.png",
                        ),
                        array(
                            "param_name"  => "modules_category_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
                        ),
                        array(
                            "param_name"  => "show_cat1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
                        ),
                        array(
                            "param_name"  => "show_date1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
                        ),
                        array(
                            "param_name"  => "auth_date_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_review1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show review stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
                        ),
                        array(
                            "param_name"  => "review_space1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'review_size1',
                            'type'        => 'range-responsive',
                            'value'       => '2.5',
                            'heading'     => 'Review stars size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name"  => "review_distance1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Distance between rating stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 2',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size2",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
                        array(
                            'param_name'  => 'image_alignment2',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_v_alignment.png",
                        ),
                        array(
                            "param_name"  => "image_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "30",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
                        array(
                            "param_name"  => "image_height2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "158px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name"  => "video_icon2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Video icon size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name"  => "video_icon_pos2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Center'  => 'center',
                                'Corner' => 'corner',
                            ),
                            "heading"     => 'Video icon position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
                        ),
                        array(
                            "param_name"  => "meta_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
                        ),
                        array(
                            "param_name"  => "meta_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "11px 15px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
                        ),
                        array(
                            "param_name"  => "art_title_padd2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_top_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 7px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_spacing.png",
                        ),
                        array(
                            "param_name"  => "modules_category_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
                        ),
                        array(
                            "param_name"  => "show_cat2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
                        ),
                        array(
                            "param_name"  => "show_date2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
                        ),
                        array(
                            "param_name"  => "auth_date_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_review2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show review stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
                        ),
                        array(
                            "param_name"  => "review_space2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'review_size2',
                            'type'        => 'range-responsive',
                            'value'       => '2.5',
                            'heading'     => 'Review stars size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '10',
                            'range_step'  => '0.5',
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name"  => "review_distance2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Distance between rating stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Module fonts',
                            "value" => "",
                            "class" => "",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title1', true, 'Module 1 title', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_cat1', false, 'Module 1 category tag', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_meta1', false, 'Module 1 meta info', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_title2', false, 'Module 2 title', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_cat2', false, 'Module 2 category tag', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', '' ),
                    td_config_helper::get_map_block_font_array( 'f_meta2', false, 'Module 2 meta info', 'Style', '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', '' ),
                    td_config_helper::mix_blend(),
                    td_config_helper::image_filters(),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay color",
                            "value" => "",
                            "class" => "td-colorpicker-double-a",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_h_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay hover color",
                            "value" => "",
                            "class" => "td-colorpicker-double-b",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_1",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 1",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_2",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 2",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_3",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 3",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_4",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 4",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name"  => "lightsky",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Lightsky",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta info background',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
                        ),
                        array(
                            "param_name"  => "meta_shadow",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Meta info shadow off",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Article title text color',
                            "param_name"  => "title_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_article_title.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Article title text hover',
                            "param_name"  => "title_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title background color',
                            "param_name"  => "title_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name"  => "title_shadow",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Article title shadow off",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Category background',
                            "param_name"  => "cat_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_bg.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Category background hover',
                            "param_name"  => "cat_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Category text color',
                            "param_name"  => "cat_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_text.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Category text hover',
                            "param_name"  => "cat_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Author text color',
                            "param_name"  => "author_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_color.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Author text hover',
                            "param_name"  => "author_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date text color',
                            "param_name"  => "date_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_color.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author & date background color',
                            "param_name"  => "auth_date_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review stars color',
                            "param_name"  => "review_stars",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                    ),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_flex_4',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 4',
                "base" => 'td_block_big_grid_flex_4',
                "class" => 'td_block_big_grid_flex_4',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_4',
                'file' => TDC_PATH_LEGACY . '/includes/shortcodes/td_block_big_grid_flex_4.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "meta_info_vert" => "content-vert-bottom",
                                "image_zoom" => "yes",
                                "show_author2" => "none",
                                "show_date2" => "none",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "image_height2" => "eyJwaG9uZSI6IjE0MHB4IiwicG9ydHJhaXQiOiIxNTBweCIsImxhbmRzY2FwZSI6IjIwMHB4In0=",
                                "image_height1" => "eyJwaG9uZSI6IjI2MHB4IiwibGFuZHNjYXBlIjoiNDEwcHgiLCJwb3J0cmFpdCI6IjMxMHB4In0=",
                                "modules_gap" => "eyJwaG9uZSI6IjMifQ==",
                                "meta_padding2" => "eyJwaG9uZSI6IjE2cHggMTVweCAxMXB4IiwicG9ydHJhaXQiOiIxMXB4IDEwcHggNnB4In0=",
                                "meta_padding1" => "eyJwaG9uZSI6IjE1cHggMThweCIsInBvcnRyYWl0IjoiMjJweCAxMHB4In0=",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "modules_category_margin2" => "eyJwb3J0cmFpdCI6IjBweCAwcHggNHB4IDBweCJ9",
                                "modules_category_margin1" => "eyJwb3J0cmFpdCI6IjBweCAwcHggN3B4IDBweCJ9",
                                "art_title1" => "eyJwb3J0cmFpdCI6IjBweCAwcHggNnB4IDBweCJ9",
                                "image_width1" => "eyJwaG9uZSI6IjEwMCJ9",
                                "image_size" => "",
                                "image_size2" => ""
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "394",
                                "f_title2_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title1_font_family" =>        "721",
                                "f_title2_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "507",
                                "f_title2_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "653",
                                "f_title2_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "147",
                                "f_title2_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "445",
                                "f_title2_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "406",
                                "f_title2_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "646",
                                "f_title2_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "41",
                                "f_title2_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "502",
                                "f_title2_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "331",
                                "f_title2_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "663",
                                "f_title2_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "639",
                                "f_title2_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "",
                                "f_title2_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxOCIsInBvcnRyYWl0IjoiMTYifQ==",
                                "f_title1_font_line_height" => "1.4",
                                "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyNCIsInBvcnRyYWl0IjoiMjIifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "eyJhbGwiOiIyMCIsInBvcnRyYWl0IjoiMTYiLCJwaG9uZSI6IjE0In0=",
                                "f_title2_font_line_height" => "1.2",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "",
                                "f_title1_font_line_height" => "",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",

                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
                                "f_title1_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
        